<h2>Why is this an issue?</h2>
<p>A <code>try-catch</code> block is used to handle exceptions or errors that may occur during the execution of a block of code. It allows you to
catch and handle exceptions gracefully, preventing your program from terminating abruptly.</p>
<p>The code that may throw an exception is enclosed within the <code>try</code> block, while each <code>catch</code> block specifies the type of
exception it can handle. The corresponding catch block is executed if the exception matches the type specified in any catch block. It is unnecessary
to manually check the types using <code>instanceof</code> because Java automatically matches the exception type to the appropriate catch block based
on the declared exception type in the catch clauses.</p>
<h2>How to fix it</h2>
<p>Replace <code>if</code> statements that check the exception type using <code>instanceof</code> with corresponding <code>catch</code> blocks.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
try {
  /* ... */
} catch (Exception e) {
  if(e instanceof IOException) { /* ... */ }         // Noncompliant
  if(e instanceof NullPointerException{ /* ... */ }  // Noncompliant
}
```
<h4>Compliant solution</h4>

```java
try {
  /* ... */
} catch (IOException e) { /* ... */ }                // Compliant
} catch (NullPointerException e) { /* ... */ }       // Compliant
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/display/java/ERR51-J.+Prefer+user-defined+exceptions+over+more+general+exception+types">CERT,
  ERR51-J.</a> - Prefer user-defined exceptions over more general exception types </li>
  <li> <a href="https://docs.oracle.com/javase/tutorial/essential/exceptions/catch.html">Oracle - Exceptions</a> </li>
</ul>