<h2>Why is this an issue?</h2>
<p>Method or constructor references are more readable than lambda expressions in many situations, and may therefore be preferred.</p>
<p>However, method references are sometimes less concise than lambdas. In such cases, it might be preferrable to keep the lambda expression for better
readability. Therefore, this rule only raises issues on lambda expressions where the replacement method reference is shorter.</p>
<p>This rule is automatically disabled when the project’s <code>sonar.java.source</code> is lower than <code>8</code>, as lambda expressions were
introduced in Java 8.</p>
<h2>How to fix it</h2>
<p>Refer to the called method by its reference instead of wrapping it in a lambda expression.</p>
<p>For instance:</p>
<ul>
  <li> <code>null</code> checks can be replaced with references to <code>Objects::isNull</code> and <code>Objects::nonNull</code> </li>
  <li> Casts can be replaced with <code>SomeClass.class::cast</code> </li>
  <li> <code>instanceof</code> can be replaced with <code>SomeClass.class::isInstance</code> </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class A {
  void process(List<A> list) {
    list.stream()
      .filter(myListValue -> myListValue instanceof B)     // Noncompliant
      .map(listValueToMap -> (B) listValueToMap)           // Noncompliant
      .map(bValueToMap -> bValueToMap.<String>getObject()) // Noncompliant
      .forEach(o -> System.out.println(o));                // Noncompliant
  }
}

class B extends A {
  <T> T getObject() {
    return null;
  }
}
```
<h4>Compliant solution</h4>

```java
class A {
  void process(List<A> list) {
    list.stream()
      .filter(B.class::isInstance)   // Compliant
      .map(B.class::cast)            // Compliant
      .map(B::<String>getObject)     // Compliant
      .forEach(System.out::println); // Compliant
  }
}

class B extends A {
  <T> T getObject() {
    return null;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/javaOO/methodreferences.html">Method References - The Java™ Tutorials</a> </li>
</ul>