<h2>Why is this an issue?</h2>
<p>In JavaScript, object shorthand syntax is a more concise way to define properties on objects. It was introduced to make object literals more
readable and expressive.</p>
<p>In the shorthand syntax, if a variable exists in the scope with the same name as the object key you’re defining, you can omit the key-value pair
and just write the variable name. The interpreter will automatically understand that the key and the variable are linked.</p>
<p>Using object shorthand syntax can make your code cleaner and easier to read. It can also reduce the chance of making errors, as you don’t have to
repeat yourself by writing the variable name twice.</p>

```ts
let a = 1;

let myObj = {
  a : a,  // Noncompliant
  fun: function () {  // Noncompliant
    //...
  }
}
```
<p>You can omit the property name and the colon if it is the same as the local variable name. Similarly, you can omit the <code>function</code>
keyword for method definitions.</p>

```ts
let a = 1;

let myObj = {
  a,
  fun () {
    //...
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Object_initializer">Object initializer</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Object_initializer#property_definitions">Property definitions</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Object_initializer#method_definitions">Method definitions</a>
  </li>
</ul>