<h2>Why is this an issue?</h2>
<p>The return type <code>any</code> should be avoided because it prevents the type safety checks normally done by the compiler. When a function
returns a primitive type (i.e. number, string or boolean) it is safe to replace <code>any</code> with <code>number</code>, <code>string</code> or
<code>boolean</code> type respectively, or remove the return type completely and let compiler infer it.</p>
<h3>Noncompliant code example</h3>

```ts
function foo() : any { // Noncompliant
  return 1;
}
```
<h3>Compliant solution</h3>

```ts
function foo() {
  return 1;
}
// or
function foo(): number {
  return 1;
}
```