<h2>Why is this an issue?</h2>
<p>React props should be read-only because it helps to enforce the principle of immutability in React functional components. By making props
read-only, you ensure that the data passed from a parent component to a child component cannot be modified directly by the child component. This helps
maintain a clear data flow and prevents unexpected side effects.</p>
<p>If props were mutable, child components could modify the props directly, leading to unpredictable behavior and making it harder to track down bugs.
By enforcing read-only props, React promotes a more predictable and maintainable codebase. Additionally, read-only props enable performance
optimizations in React’s rendering process by avoiding unnecessary re-renders of components.</p>
<p>Overall, enforcing read-only props in React helps improve code reliability, maintainability, and performance.</p>

```ts
interface Props {
  name: string;
}

function Welcome(props: Props) { // Noncompliant: The component props are not read-only
  return <div>Hello {props.name}</div>;
}
```
<p>You should use TypeScript’s utility type <code>Readonly</code> to make your functional component props read-only.</p>

```ts
interface Props {
  name: string;
}

function Welcome(props: Readonly<Props>) {
  return <div>Hello {props.name}</div>;
}
```
<p>Alternatively, you can use TypeScript’s modifier <code>readonly</code> to mark all the props of your functional component individually as
read-only.</p>

```ts
interface Props {
  readonly name: string;
}

function Welcome(props: Props) {
  return <div>Hello {props.name}</div>;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component">Passing Props to a Component</a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/utility-types.html#readonlytype">Readonly&lt;Type&gt;</a>
  </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/classes.html#readonly">readonly</a> </li>
</ul>