# AnyObject Protocol

Prefer using `AnyObject` over `class` for class-only protocols.

* **Identifier:** anyobject_protocol
* **Supports autocorrection:** Yes
* **Kind:** lint
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 4.1.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
protocol SomeProtocol {}

```

```swift
protocol SomeClassOnlyProtocol: AnyObject {}

```

```swift
protocol SomeClassOnlyProtocol: AnyObject, SomeInheritedProtocol {}

```

```swift
@objc protocol SomeClassOnlyProtocol: AnyObject, SomeInheritedProtocol {}

```

## Triggering Examples

```swift
protocol SomeClassOnlyProtocol: ↓class {}

```

```swift
protocol SomeClassOnlyProtocol: ↓class, SomeInheritedProtocol {}

```

```swift
@objc protocol SomeClassOnlyProtocol: ↓class, SomeInheritedProtocol {}

```