Repeating a class name in its members can make the code less clear and more verbose.
Instead, strive for clarity and conciseness by avoiding redundancy in naming.

# What Does This Check Look For?

This check identifies fields or methods within a class that include the class's name in their own names, signaling potential redundancy.

# Why is This a Problem?

Including the class name in its members' names introduces unnecessary verbosity, reducing the comprehensibility of the code. It can make the code harder to read and understand, especially for new developers or when revisiting the code after some time. This practice can also lead to longer, more cumbersome names where the context already provided by the class should suffice.

# How Can I Resolve This?

Consider renaming the members to exclude the class name, focusing on what the member represents or its purpose rather than where it belongs. This approach enhances clarity and maintains code conciseness, making the codebase easier to navigate and understand.

# Examples

## Non-Compliant

```java
public class Customer {
    private String customerName;     // non-compliant: member name repeats class name
    public void setCustomerAddress(String address) {//...
    }   // non-compliant: method name repeats class name
}
```

## Compliant

```java
public class Customer {
    private String name;     // compliant: concise and clear
    public void setAddress(String address) {//...
    }   // compliant: method name is concise and contextually clear
}
```
