This check finds code that is unreachable because it follows an exit statement.

An exit statement is a statement that leaves the current execution scope such as a `break` within a loop
or a `return` within a function.
The considered exit statements include `break`, `continue`, `raise`, `return`, and `throw`.
In some languages, unreachable code is also reported by the compiler, for instance, the Java compiler generates
an error and the C# compiler a warning. Unreachable code is often also called "dead" code.

Note that this check does not perform a control flow analysis, but a local statement analysis.

# Why is This a Problem?

Unreachable code is considered undesirable as it adds unnecessary complexity and makes it more difficult
to understand and maintain the code base.

# How Can I Resolve This?

Since unreachable code is never executed, it can be simply removed.

## Example (Python)

### Before (with unreachable code)

```Python
def foo(a):
    x = a + 42
    return x
    if x > 100:          # <- unreachable
        print("x =", x)  # <- unreachable
```

### After (unreachable code removed)

```Python
def foo(a):
    x = a + 42
    return x
```

## Example (Objective-C)

### Before (with unreachable code)
```objective-c
int bar(int a) {
    int x = 0;
    for (int i = 0; i < 10; i++) {
        if (i == 5)
            continue;
        if (i == a) {
            break;
            NSLog(@"Break at %d == %d", i, a);  // <- unreachable
        }
        x += i / 2;
        NSLog(@"%d", i);
    }
    return x;
}
```

### After (unreachable code removed)
```objective-c
int bar(int a) {
    int x = 0;
    for (int i = 0; i < 10; i++) {
        if (i == 5)
            continue;
        if (i == a) {
            break;
        }
        x += i / 2;
        NSLog(@"%d", i);
    }
    return x;
}
```

## References

- [Java Language Specification: Unreachable Statements](https://docs.oracle.com/javase/specs/jls/se17/html/jls-14.html#jls-14.22)
- [C# Compiler Warning: CS0162](https://docs.microsoft.com/en-us/dotnet/csharp/misc/cs0162)
