Using comparative and superlative language can make your descriptions less precise and clear.
Prefer exact quantification over comparatives or superlatives.

## What Does This Check Look For?

This check scans the fields of items looking for instances of comparative and superlative language.
It reports a finding whenever it encounters a sentence or phrase using words like "better," "best," "worse," "worst," "more," or "most."

## Why is This a Problem?

Utilizing comparative and superlative language may lead to ambiguous or imprecise specifications.
To enhance communication, it is recommended to refrain from using these forms and opt for more precise and clear expressions.

## How Can I Resolve This?

You can resolve this issue by revising the detected instances of comparative and superlative language to use more concrete and specific terms.
For instance, instead of saying "better," describe what makes something better.

## Examples

### Non-Compliant

```markdown
"This approach is better than the previous one."
// non-compliant: Comparative language used.
```

### Compliant
```markdown
"This approach reduces costs compared to the previous one."
// compliant: Specific language used.
```