import{_ as p,c,ak as i,O as t,z as s,L as n,o as d,b as e}from"./chunks/framework.D4LivsWb.js";const w=JSON.parse('{"title":"Generating Testwise Coverage","description":"","frontmatter":{"title":"Generating Testwise Coverage"},"headers":[],"relativePath":"tutorial/generating-testwise-coverage/index.md","filePath":"tutorial/generating-testwise-coverage/index.md"}'),h={name:"tutorial/generating-testwise-coverage/index.md"};function u(g,a,m,f,v,k){const r=n("ZipDownload"),o=n("PluginTabsTab"),l=n("PluginTabs");return d(),c("div",null,[a[3]||(a[3]=i('<h1 id="generating-testwise-coverage" tabindex="-1">Generating Testwise Coverage <a class="header-anchor" href="#generating-testwise-coverage" aria-label="Permalink to &quot;Generating Testwise Coverage&quot;">​</a></h1><p>In order to use the Test Impact Analysis, you&#39;ll need to provide per-test coverage in the <a href="./../../reference/upload-formats-and-samples/testwise-coverage/">Testwise Coverage report</a> format. Unfortunately, most coverage tools do not provide coverage information on a per-test level, but rather for the full test run.</p><p>We offer plugins for certain languages and test runners, such as Java+JUnit 5 with Maven/Gradle, which can <a href="./../../howto/providing-testwise-coverage/#tia-for-the-java-virtual-machine-jvm">collect Testwise Coverage</a>. It is recommended that you use these plugins if they are available for your language and test runner. We are also working on extending the support for other languages and test runners.</p><p>If you use technologies for which we do not have plugins available, but are already able to gather coverage data at a per-test(-suite) level, you can use our <a href="./../../reference/cli/teamscale-build/"><code>teamscale-build</code> command-line tool</a>.</p><p>This tutorial will teach you how to use <code>teamscale-build</code> to convert these reports into a single Testwise Coverage report. This will allow you to use the <a href="./../improving-test-efficiency/#improving-test-execution-efficiency-with-test-impact-analysis">Test Impact Analysis</a>.</p><h2 id="_1-download" tabindex="-1">1. Download <a class="header-anchor" href="#_1-download" aria-label="Permalink to &quot;1. Download&quot;">​</a></h2><p>Download the <code>teamscale-build</code> tool from <a href="./../../reference/cli/teamscale-build/#download">here</a> and install it.</p><h2 id="_2-place-all-coverage-files-into-a-directory" tabindex="-1">2. Place All Coverage Files Into a Directory <a class="header-anchor" href="#_2-place-all-coverage-files-into-a-directory" aria-label="Permalink to &quot;2. Place All Coverage Files Into a Directory&quot;">​</a></h2><p>For this tutorial, we have prepared two sample coverage reports. You can download them from here:</p>',9)),t(r,{title:"Sample Reports",link:"/assets/tutorial/generating-testwise-coverage/sample_reports.zip"}),a[4]||(a[4]=i(`<p>The ZIP file contains the following files:</p><div class="language-text vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">text</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>sample_reports/</span></span>
<span class="line"><span>├── expected_output.json</span></span>
<span class="line"><span>└── input_files/</span></span>
<span class="line"><span>    ├── AnotherTest/</span></span>
<span class="line"><span>    │   ├── metadata.json</span></span>
<span class="line"><span>    │   └── SIMPLE/</span></span>
<span class="line"><span>    │       └── report1.simple</span></span>
<span class="line"><span>    └── SomeTest/</span></span>
<span class="line"><span>        ├── metadata.json</span></span>
<span class="line"><span>        └── SIMPLE/</span></span>
<span class="line"><span>            └── report1.simple</span></span></code></pre></div><p>The <code>expected_output.json</code> is a copy of the Testwise Coverage report that we are about to generate. The <code>input_files</code> contain the coverage reports. The reports are given in the <a href="./../../reference/upload-formats-and-samples/#example-file-for-teamscale-simple-coverage">Teamscale Simple Coverage</a> format, but most of the <a href="./../../reference/supported-technologies/test-coverage/#test-coverage-tools">Teamscale-supported coverage formats</a> are also <a href="./../../reference/cli/teamscale-build/#input-coverage-format">supported by <code>teamscale-build</code></a>. The format of the reports is encoded in the name of the folder containing the reports.</p><p>The <code>metadata.json</code> files contain metadata about each test such as its path, duration and result. See <a href="./../../reference/cli/teamscale-build/#input-path-structure">the <code>teamscale-build</code> documentation for all available attributes</a>.</p><div class="warning custom-block"><p class="custom-block-title">Creating the folder structure</p><p>For your own tests, you are responsible for creating the correct folder structure and <code>metadata.json</code> files yourself.</p></div><h2 id="_3-convert-the-reports" tabindex="-1">3. Convert the Reports <a class="header-anchor" href="#_3-convert-the-reports" aria-label="Permalink to &quot;3. Convert the Reports&quot;">​</a></h2><p>Execute the following command to convert all Simple coverage reports from the directory <code>input_files</code> to a single Testwise Coverage report and save this report to the file <code>testwise-report.json</code>.</p>`,7)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[0]||(a[0]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ./input_files"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise-report.json")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[1]||(a[1]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe coverage testwise -i .\\input_files -o testwise-report.json")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[2]||(a[2]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ./input_files"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise-report.json")])])])],-1)])]),_:1})]),_:1}),a[5]||(a[5]=i('<h2 id="_4-uploading-the-generated-testwise-coverage-report-to-teamscale" tabindex="-1">4. Uploading the Generated Testwise Coverage Report to Teamscale <a class="header-anchor" href="#_4-uploading-the-generated-testwise-coverage-report-to-teamscale" aria-label="Permalink to &quot;4. Uploading the Generated Testwise Coverage Report to Teamscale&quot;">​</a></h2><p>Now, repeat the same process for your own tests to generate a testwise coverage report for your software system.</p><p>To view the result in Teamscale, use our <a href="./../../howto/uploading-external-data/#upload-via-command-line">upload tool <code>teamscale-upload</code></a> to upload the generated <code>testwise-report.json</code> to your Teamscale instance. Specify the format <code>TESTWISE_COVERAGE</code>.</p><p>You can view the results under <em>Metrics</em> &gt; <em>Tests</em>.</p>',4))])}const _=p(h,[["render",u]]);export{w as __pageData,_ as default};
