/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import jetbrains.exodus.tree.patricia.PatriciaTreeWithDuplicatesMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatriciaTreeEmpty
extends PatriciaTreeBase {
    private final boolean hasDuplicates;

    public PatriciaTreeEmpty(@NotNull Log log, int structureId, boolean hasDuplicates) {
        super(log, structureId);
        this.size = 0L;
        this.hasDuplicates = hasDuplicates;
    }

    @Override
    @NotNull
    public ITreeMutable getMutableCopy() {
        PatriciaTreeMutable treeMutable = new PatriciaTreeMutable(this.log, this.structureId, 0L, this.getRoot());
        return this.hasDuplicates ? new PatriciaTreeWithDuplicatesMutable(treeMutable) : treeMutable;
    }

    @Override
    public long getRootAddress() {
        return -1L;
    }

    @Override
    public ITreeCursor openCursor() {
        return ITreeCursor.EMPTY_CURSOR;
    }

    @Override
    ImmutableNode getRoot() {
        return new ImmutableNode();
    }

    @Override
    @Nullable
    protected NodeBase getNode(@NotNull ByteIterable key) {
        return null;
    }
}

