/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-abap-only-one-exception", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbapOnlyOneExceptionCheck
extends CheckImplementationBase {
    private static final ITokenMatcher METHODS_DECLARATION_SECTION_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.USING, ETokenType.CHANGING, ETokenType.IMPORTING, ETokenType.EXPORTING, ETokenType.RETURNING, ETokenType.TABLES, ETokenType.TESTING, ETokenType.RAISING, ETokenType.DOT});

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("method declaration") || !AbapOnlyOneExceptionCheck.methodCanRaiseMultipleExceptions(method)) continue;
            this.buildFinding("Method can throw multiple exception types", this.buildLocation().forEntity(method)).createAndStore();
        }
    }

    private static boolean methodCanRaiseMultipleExceptions(ShallowEntity methodDeclaration) {
        UnmodifiableList declarationStartTokens = methodDeclaration.ownStartTokens();
        int raisingIndex = TokenStreamUtils.firstTokenMatching((List)declarationStartTokens, (ITokenMatcher)ETokenType.RAISING);
        if (raisingIndex == -1 || raisingIndex == declarationStartTokens.size()) {
            return false;
        }
        int raisingSectionEnd = TokenStreamUtils.firstTokenMatching((List)declarationStartTokens, (int)(raisingIndex + 1), (int)declarationStartTokens.size(), (ITokenMatcher)METHODS_DECLARATION_SECTION_TOKENS);
        if (raisingSectionEnd == -1) {
            return false;
        }
        UnmodifiableList raisingSectionTokens = declarationStartTokens.subList(raisingIndex, raisingSectionEnd);
        List raisedExceptionTypes = TokenStreamUtils.findAllTokens((List)raisingSectionTokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        return raisedExceptionTypes.size() > 1;
    }
}

