/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.HeaderFileCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;

@Check(id="cqse-method-definition-in-header", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_CPP, ELanguage.OBJECTIVE_C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodDefinitionInHeaderCheck
extends HeaderFileCheckBase {
    private static final String IS_NOT_TEMPLATE = "not(preceding-sibling::*[1][subtype('template')])";
    private static final String IS_NOT_INLINE = "not(anytoken('" + ETokenType.INLINE.name() + "'))";
    private static final String IS_FUNCTION = "subtype('function')";
    private static final String WRONG_FUNCTION = "./METHOD[subtype('function') and not(preceding-sibling::*[1][subtype('template')]) and " + IS_NOT_INLINE + "]";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    @Override
    public void executeHeaderCheck() throws CheckException {
        for (ShallowEntity entity : this.select(WRONG_FUNCTION)) {
            this.buildFinding("`" + entity.getName() + "` should not be defined in the header", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

