/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-include-directives-should-not-be-preceded-by-code", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class IncludeDirectivesShouldNotBePrecededByCodeCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        IToken lastIncludeToken = null;
        boolean hadCode = false;
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.TEMPLATE && CppCheckUtils.isHeaderFile((String)this.context.getUniformPath())) {
                return;
            }
            if (IncludeDirectivesShouldNotBePrecededByCodeCheck.isCodeToken(token, lastIncludeToken)) {
                hadCode = true;
                continue;
            }
            if (hadCode && token.getType() == ETokenType.PREPROCESSOR_INCLUDE) {
                this.buildFinding("Includes shall only be preceded by preprocessor statements or comments", this.buildLocation().forToken(token)).createAndStore();
            }
            if (token.getType() != ETokenType.PREPROCESSOR_INCLUDE) continue;
            lastIncludeToken = token;
        }
    }

    private static boolean isCodeToken(IToken token, IToken lastIncludeToken) {
        if (lastIncludeToken != null && token.getLineNumber() == lastIncludeToken.getLineNumber() && (token.getType() == ETokenType.IDENTIFIER || token.getType().getTokenClass() == ETokenType.ETokenClass.LITERAL || token.getType() == ETokenType.LPAREN || token.getType() == ETokenType.RPAREN || token.getType() == ETokenType.COMMA)) {
            return false;
        }
        String text = token.getText();
        return !text.startsWith("#") && !text.startsWith("/") && !text.startsWith("__") && token.getType() != ETokenType.LBRACE && token.getType() != ETokenType.RBRACE && token.getType() != ETokenType.EXTERN && !text.equals("\"C\"");
    }
}

