/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaAnalysisUtils;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;

@Check(id="cqse-avoid-calling-contains-on-list", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidCallingContainsOnListCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Calling `contains()` on lists is inefficient";
    private static final JavaMethodCallMatcher CONTAINS_ON_LIST_CALL_MATCHER = JavaMethodCallMatcher.create().onTypes(JavaAnalysisUtils.COMMON_LIST_IMPLEMENTATIONS).withKnownMethodReturningSameType(new String[]{"subList"}).withTargetMethodNames(new String[]{"contains"}).withParameterCount(1);

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall containsCall : CONTAINS_ON_LIST_CALL_MATCHER.find(this.context, typeResolver)) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(containsCall.token())).createAndStore();
        }
    }
}

