/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaAnalysisUtils;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-avoid-list-adding-itself", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidListAddingItselfCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher LIST_ADD_ALL_CALLS_MATCHERS = JavaMethodCallMatcher.create().onTypes(JavaAnalysisUtils.COMMON_LIST_IMPLEMENTATIONS).withTargetMethodNames(new String[]{"addAll"}).withParameterCount(1);

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall addAllCall : LIST_ADD_ALL_CALLS_MATCHERS.find(this.context, typeResolver)) {
            UnmodifiableList statementTokens = addAllCall.entity().ownStartTokens();
            this.checkOperands((List<IToken>)statementTokens, TokenStreamUtils.indexOfByOffset((List)statementTokens, (int)addAllCall.token().getOffset()));
        }
    }

    private void checkOperands(List<IToken> tokens, int addOperatorIndex) {
        int firstParameterIndex = addOperatorIndex + 2;
        if (!AvoidListAddingItselfCheck.callerSequenceEqualsParameters(tokens, addOperatorIndex, firstParameterIndex)) {
            return;
        }
        int firstOperandIndex = addOperatorIndex - 2;
        if (firstOperandIndex < 0 || tokens.size() < firstParameterIndex + 1) {
            return;
        }
        IToken firstOperand = tokens.get(firstOperandIndex);
        this.buildFinding("Adding list type object " + MarkupUtils.formatAsSourceCode((String)firstOperand.getText()) + " to itself is not recommended.", this.buildLocation().forToken(firstOperand)).createAndStore();
    }

    private static boolean callerSequenceEqualsParameters(List<IToken> tokens, int addOperatorIndex, int firstParameterIndex) {
        int firstIndexOfCallerSequence = AvoidListAddingItselfCheck.getFirstIndexOfCallerSequence(tokens, addOperatorIndex);
        if (firstIndexOfCallerSequence == addOperatorIndex - 1 && !tokens.get(firstIndexOfCallerSequence).getType().equals((Object)ETokenType.IDENTIFIER)) {
            return false;
        }
        List<IToken> callingSequence = tokens.subList(firstIndexOfCallerSequence, addOperatorIndex - 1);
        for (int i = 0; i < callingSequence.size(); ++i) {
            if (callingSequence.get(i).getText().equals(tokens.get(firstParameterIndex + i).getText())) continue;
            return false;
        }
        return true;
    }

    private static int getFirstIndexOfCallerSequence(List<IToken> tokens, int addOperatorIndex) {
        HashSet<ETokenType> delimiter = new HashSet<ETokenType>(Arrays.asList(ETokenType.IDENTIFIER, ETokenType.DOT));
        for (int i = addOperatorIndex - 1; i > 0; --i) {
            if (delimiter.contains(tokens.get(i).getType())) continue;
            return i + 1;
        }
        return 0;
    }
}

