/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-maximum-type-name-length", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MaximumTypeNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum name length", description="The maximum allowed length of a type name.")
    private int maximumNameLength = 30;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (entity.getName() != null && entity.getName().length() > this.maximumNameLength) {
            this.buildFinding("Name " + MarkupUtils.formatAsSourceCode((String)entity.getName()) + " should not be longer than " + this.maximumNameLength + " characters", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

