/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class JavaCriticalSectionUtils {
    private static final int SYNCHRONIZED_BLOCK_GROUP = 0;
    private static final TokenPattern SYNCHRONIZED_BLOCK_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.SYNCHRONIZED}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).skipNested((Object)ETokenType.LBRACE, (Object)ETokenType.RBRACE, false).group(0);
    private static final int LOCK_OBJECT_GROUP = 0;
    private static final int END_LOCK_GROUP = 1;
    private static final TokenPattern LOCK_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT}).alternative(new Object[]{TokenPattern.text((String)"lock"), TokenPattern.text((String)"lockInterruptibly"), TokenPattern.text((String)"tryLock")}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(1);
    private static final int BEGIN_UNLOCK_GROUP = 0;
    private static final TokenPattern UNLOCK_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{TokenPattern.text((String)"unlock")}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false);

    public static List<MatchGroupElement> getSynchronizedMethodCriticalSections(ShallowEntity method) {
        Preconditions.checkArgument((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0);
        if ("lambda".equals(method.getSubtype())) {
            return Collections.emptyList();
        }
        UnmodifiableList startTokens = method.ownStartTokens();
        if (!TokenStreamUtils.contains((List)startTokens, (ETokenType)ETokenType.SYNCHRONIZED)) {
            return Collections.emptyList();
        }
        UnmodifiableList endTokens = method.ownEndTokens();
        if (endTokens.isEmpty()) {
            return Collections.singletonList(new MatchGroupElement(Collections.emptyList()));
        }
        UnmodifiableList methodTokens = method.includedTokens();
        IToken lastStartToken = (IToken)CollectionUtils.getLast((List)startTokens);
        IToken firstEndToken = (IToken)endTokens.get(0);
        MatchGroupElement criticalSection = new MatchGroupElement(methodTokens.subList(methodTokens.indexOf(lastStartToken) + 1, methodTokens.indexOf(firstEndToken)));
        return Collections.singletonList(criticalSection);
    }

    public static List<MatchGroupElement> getSynchronizedBlockCriticalSections(ShallowEntity method) {
        Preconditions.checkArgument((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0);
        List synchronizedBlocks = SYNCHRONIZED_BLOCK_PATTERN.findAll((List)method.includedTokens());
        if (synchronizedBlocks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MatchGroupElement> criticalSections = new ArrayList<MatchGroupElement>();
        for (TokenPatternMatch synchronizedBlock : synchronizedBlocks) {
            List blockTokens = synchronizedBlock.groupTokens(0);
            List bodyTokens = blockTokens.subList(1, blockTokens.size() - 1);
            criticalSections.add(new MatchGroupElement(bodyTokens));
        }
        return criticalSections;
    }

    public static List<MatchGroupElement> getLockUnlockCriticalSections(ShallowEntity method) {
        Preconditions.checkArgument((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0);
        return JavaCriticalSectionUtils.getLockUnlockCriticalSections((List<IToken>)method.includedTokens());
    }

    @VisibleForTesting
    static List<MatchGroupElement> getLockUnlockCriticalSections(List<IToken> methodTokens) {
        List lockCalls = LOCK_CALL_PATTERN.findAll(methodTokens);
        if (lockCalls.isEmpty()) {
            return Collections.emptyList();
        }
        List unlockCalls = UNLOCK_CALL_PATTERN.findAll(methodTokens);
        if (unlockCalls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MatchGroupElement> criticalSections = new ArrayList<MatchGroupElement>();
        for (TokenPatternMatch lockCall : lockCalls) {
            for (TokenPatternMatch unlockCall : unlockCalls) {
                IToken lockObject = (IToken)Iterables.getOnlyElement((Iterable)lockCall.groupTokens(0));
                IToken unlockObject = (IToken)Iterables.getOnlyElement((Iterable)unlockCall.groupTokens(0));
                if (lockObject.getOffset() > unlockObject.getOffset() || !lockObject.getText().equals(unlockObject.getText())) continue;
                IToken lastLockToken = (IToken)CollectionUtils.getLast((List)lockCall.groupTokens(1));
                IToken firstUnlockToken = (IToken)unlockCall.groupTokens(0).get(0);
                MatchGroupElement criticalSection = new MatchGroupElement(methodTokens.subList(methodTokens.indexOf(lastLockToken) + 1, methodTokens.indexOf(firstUnlockToken)));
                criticalSections.add(criticalSection);
            }
        }
        return criticalSections;
    }

    private JavaCriticalSectionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

