/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.streams;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-do-not-use-parallel-streams", languages={ELanguage.JAVA}, defaultEnablement=EFindingEnablement.OFF, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotUseParallelStreams
extends CheckImplementationBase {
    private static final Set<String> PARALLEL_STREAM_METHODS = new HashSet<String>(Arrays.asList("parallelStream", "parallel"));

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.includedTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            if (((IToken)tokens.get(i)).getType() != ETokenType.DOT || i + 3 >= tokens.size() || ((IToken)tokens.get(i + 1)).getType() != ETokenType.IDENTIFIER || !PARALLEL_STREAM_METHODS.contains(((IToken)tokens.get(i + 1)).getText()) || ((IToken)tokens.get(i + 2)).getType() != ETokenType.LPAREN || ((IToken)tokens.get(i + 3)).getType() != ETokenType.RPAREN) continue;
            this.buildFinding("Do not use parallel streams", this.buildLocation().forToken((IToken)tokens.get(i + 1))).createAndStore();
        }
    }
}

