/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.ESimulinkReservedNameType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0232", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUsableCharactersForParameterNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the parameter name so that it does not start with a digit or an underscore, end with an underscore, have more than one consecutive underscore or consist of either a restricted keyword or MATLAB function name.");
    private final Set<ESimulinkNameCheckType> typesToCheck = new HashSet<ESimulinkNameCheckType>();
    private static final String LOCATION_MODEL_WORKSPACE = " (model workspace)";
    private static final String FINDING_MESSAGE_PATTERN_BLOCK = "Simulink parameter name {0}{1} {2}";
    private static final String FINDING_MESSAGE_PATTERN_DICTIONARY = "Simulink parameter name {0} {1}";
    @CheckOption(name="Disallow non-alphanumeric characters in parameter names", description="If set, parameter names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in parameter names", description="If set, parameter names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in parameter names", description="If set, parameter names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in parameter names", description="If set, parameter names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in parameter names", description="If set, parameter names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow parameter names as reserved MATLAB keywords", description="If set, parameter names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow parameter names as MATLAB function names", description="If set, parameter names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = true;
    @CheckOption(name="Whitelisted parameter names", description="List of all parameter names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";

    public void initialize() {
        this.typesToCheck.addAll(SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName));
    }

    public void execute() {
        this.context.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile().ifPresent(this::checkDataDictionary);
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkModel);
    }

    private void checkDataDictionary(SimulinkDataDictionary dataDictionary) {
        List parameters = dataDictionary.getEntries().stream().filter(entry -> entry instanceof SimulinkParameter).collect(Collectors.toList());
        for (ISimulinkDataDictionaryEntry parameter : parameters) {
            this.checkIfParameterNameIsValid(parameter);
        }
    }

    private void checkModel(SimulinkModel model) {
        HashSet<String> parameterNamesInModelWorkspace = new HashSet<String>(SimulinkUtils.getSimulinkParameterNames((SimulinkModel)model));
        HashSet<String> parameterNamesCheckedOnBlocks = new HashSet<String>();
        Set parameterNamesInDictionaries = SimulinkUtils.getAllNamesOfDictionaryType(new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class)), SimulinkParameter.class);
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            List<IToken> extractedIdentifierTokens = SimulinkUsableCharactersForParameterNamesCheck.getIdentifiersFromParameterValueExpression(block, this.context.getUniformPath());
            for (IToken token : extractedIdentifierTokens) {
                String parameterName = token.getText();
                if (parameterNamesInDictionaries.contains(parameterName)) continue;
                String parameterOrigin = SimulinkUsableCharactersForParameterNamesCheck.getParameterOrigin(parameterName, parameterNamesInModelWorkspace);
                if (SimulinkNameChecker.getNameType(parameterName) != ESimulinkReservedNameType.NON_RESERVED_NAME && !parameterOrigin.equals(LOCATION_MODEL_WORKSPACE)) continue;
                this.checkIfParameterNameIsValid(parameterName, block, parameterOrigin);
                parameterNamesCheckedOnBlocks.add(parameterName);
            }
        }
        for (String parameterName : CollectionUtils.differenceSet(parameterNamesInModelWorkspace, (Collection[])new Collection[]{parameterNamesCheckedOnBlocks})) {
            String parameterOrigin = SimulinkUsableCharactersForParameterNamesCheck.getParameterOrigin(parameterName, parameterNamesInModelWorkspace);
            this.checkIfParameterNameIsValid(parameterName, (SimulinkBlock)model, parameterOrigin);
        }
    }

    private void checkIfParameterNameIsValid(String parameterName, SimulinkBlock findingsBlock, String parameterOrigin) {
        List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(parameterName, this.typesToCheck, this.whitelistedNames);
        for (ESimulinkNameCheckType failedCheck : failedChecks) {
            this.createFindingFromNameCheckType(failedCheck, parameterName, this.buildLocation().forSimulinkBlock(findingsBlock), parameterOrigin);
        }
    }

    private void checkIfParameterNameIsValid(ISimulinkDataDictionaryEntry parameter) {
        List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(parameter.getName(), this.typesToCheck, this.whitelistedNames);
        for (ESimulinkNameCheckType failedCheck : failedChecks) {
            this.createFindingFromNameCheckType(failedCheck, parameter.getName(), this.buildLocation().forSimulinkDataDictionaryEntry(parameter), null);
        }
    }

    private void createFindingFromNameCheckType(ESimulinkNameCheckType checkType, String parameterName, QualifiedNameLocation findingsLocation, String parameterOrigin) {
        switch (checkType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.createFinding(parameterName, "shall contain only letters, digits, and underscores", findingsLocation, parameterOrigin);
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.createFinding(parameterName, "starts with a digit", findingsLocation, parameterOrigin);
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.createFinding(parameterName, "contains consecutive underscores", findingsLocation, parameterOrigin);
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.createFinding(parameterName, "starts with an underscore", findingsLocation, parameterOrigin);
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.createFinding(parameterName, "ends with an underscore", findingsLocation, parameterOrigin);
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.createFinding(parameterName, "is a MATLAB function name", findingsLocation, parameterOrigin);
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.createFinding(parameterName, "is a reserved MATLAB keyword", findingsLocation, parameterOrigin);
                break;
            }
        }
    }

    private void createFinding(String parameterName, String findingMessagePart, QualifiedNameLocation findingsLocation, String parameterOrigin) {
        String findingMessage = parameterOrigin == null ? MessageFormat.format(FINDING_MESSAGE_PATTERN_DICTIONARY, MarkupUtils.formatAsSourceCode((String)parameterName), findingMessagePart) : MessageFormat.format(FINDING_MESSAGE_PATTERN_BLOCK, MarkupUtils.formatAsSourceCode((String)parameterName), parameterOrigin, findingMessagePart);
        this.buildFinding(findingMessage, (ElementLocation)findingsLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    public static List<IToken> getIdentifiersFromParameterValueExpression(SimulinkBlock block, String uniformPath) {
        String rawParameterNameFromBlock = null;
        if (block.isOfType("Constant")) {
            rawParameterNameFromBlock = block.getDeclaredParameter("Value");
        } else if (block.isOfType("Gain")) {
            rawParameterNameFromBlock = block.getDeclaredParameter("Gain");
        } else if (block.isOfType("Delay")) {
            rawParameterNameFromBlock = block.getDeclaredParameter("InitialCondition");
        } else if (block.isOfSourceType("Difference")) {
            rawParameterNameFromBlock = block.getDeclaredParameter("ICPrevInput");
        }
        if (rawParameterNameFromBlock == null) {
            return Collections.emptyList();
        }
        return ScannerUtils.getTokens((String)rawParameterNameFromBlock, (ELanguage)ELanguage.MATLAB, (String)uniformPath).stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).collect(Collectors.toList());
    }

    public static String getParameterOrigin(String parameterName, Set<String> parameterNamesInModelWorkspace) {
        if (parameterNamesInModelWorkspace.contains(parameterName)) {
            return LOCATION_MODEL_WORKSPACE;
        }
        return "";
    }
}

