/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Collections;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0640", languages={ELanguage.SIMULINK})
public class SimulinkInitialOutputInConditionalSubsystemsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "No initial output set for {0}";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set an initial output value for outports in conditional subsystems and for merge blocks that are connected to a conditional subsystem (JC_0640).");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        this.checkConditionalSubsystems(model);
        this.checkMergeBlocks(model);
    }

    private void checkConditionalSubsystems(SimulinkModel model) {
        for (SimulinkBlock subsystem : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)false, (boolean)false)) {
            if (!SimulinkUtils.isConditionalSubsystem((SimulinkBlock)subsystem)) continue;
            for (SimulinkBlock subBlock : subsystem.getSubBlocks()) {
                if (!subBlock.isOfType("Outport") || !SimulinkInitialOutputInConditionalSubsystemsCheck.initialOutputIsNotSet(subBlock)) continue;
                this.context.buildFinding(MessageFormat.format(FINDING_MESSAGE, subBlock.getName()), (ElementLocation)this.buildLocation().forSimulinkBlock(subBlock)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private void checkMergeBlocks(SimulinkModel model) {
        block0: for (SimulinkBlock mergeBlock : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Merge"), (boolean)false, (boolean)false)) {
            for (SimulinkInPort inPort : mergeBlock.getInPorts()) {
                if (!inPort.isConnected() || inPort.getLine().getSrcPort() == null || !SimulinkUtils.isConditionalSubsystem((SimulinkBlock)inPort.getLine().getSrcPort().getBlock()) || !SimulinkInitialOutputInConditionalSubsystemsCheck.initialOutputIsNotSet(mergeBlock)) continue;
                this.context.buildFinding(MessageFormat.format(FINDING_MESSAGE, mergeBlock.getName()), (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                continue block0;
            }
        }
    }

    private static boolean initialOutputIsNotSet(SimulinkBlock outPortBlock) {
        String initialOutput = outPortBlock.getParameter("InitialOutput");
        if (initialOutput == null) {
            return true;
        }
        return initialOutput.isEmpty() || "[]".equals(initialOutput);
    }
}

