/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0019", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfBitwiseOperationsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use unsigned data types instead of signed data types as input to the block.");
    private static final Set<String> BLOCK_TYPES_TO_CHECK = Set.of("Bit Clear", "Bit Set", "Bitwise Operator", "Extract Bits", "ArithShift");
    private static final Set<String> UNSIGNED_TYPES = Set.of("boolean", "uint8", "uint16", "uint32", "uint64");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (resolvedDataTypes == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!BLOCK_TYPES_TO_CHECK.contains(block.getType()) && (block.getSourceBlockName() == null || !BLOCK_TYPES_TO_CHECK.contains(block.getSourceType()))) continue;
            this.checkBitwiseBlock(block, resolvedDataTypes);
        }
    }

    private void checkBitwiseBlock(SimulinkBlock block, SimulinkResolvedDataTypes resolvedDataTypes) {
        UnmodifiableCollection inPorts = block.getInPorts();
        for (SimulinkInPort inPort : inPorts) {
            String inPortDataType = resolvedDataTypes.getInputDataType(block, inPort.getIndex());
            if (inPortDataType == null || "Unknown".equals(inPortDataType) || "NOT_CONNECTED".equals(inPortDataType) || UNSIGNED_TYPES.contains(inPortDataType)) continue;
            this.buildFinding("Bitwise block " + MarkupUtils.formatAsSourceCode((String)block.getNamePretty()) + " uses signed input type " + MarkupUtils.formatAsSourceCode((String)inPortDataType), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

