/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.authorization;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.framework.authorization.RequiresUserPermission;
import com.teamscale.service.framework.impl.authorization.AnnotatedPermissionCheckerBase;
import jakarta.ws.rs.NotFoundException;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

class UserPermissionChecker
extends AnnotatedPermissionCheckerBase<RequiresUserPermission> {
    public UserPermissionChecker() {
        super(RequiresUserPermission.class);
    }

    @Override
    protected void checkPermission(RequiresUserPermission userPermission) throws StorageException {
        String userPathParameterName = userPermission.entityPathParameter();
        List<String> userNames = this.getPathOrQueryParameters(userPathParameterName, "");
        EBasicPermission[] permissions = userPermission.value();
        for (String userName : userNames) {
            for (EBasicPermission permission : permissions) {
                this.checkUserPermission(userName, permission);
            }
        }
    }

    private void checkUserPermission(String userName, EBasicPermission permission) throws StorageException {
        if (this.serviceInfo.getUser().getUsername().equalsIgnoreCase(userName) && EnumSet.of(EBasicPermission.VIEW, EBasicPermission.EDIT).contains(permission)) {
            return;
        }
        this.checkUserExists(userName);
        this.serviceInfo.getPermissions().checkBasicPermission(EBasicPermissionScope.USERS, userName, permission);
    }

    private void checkUserExists(String userName) throws StorageException {
        if (((UserIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(UserIndex.class)).getUser(userName) == null) {
            throw new NotFoundException("User " + userName + " doesn't exist!");
        }
    }
}

