/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.parameter.RegExFlags;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.string.StringUtils;

@Provider
public class PatternConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(Pattern.class)) {
            int flags = PatternConverterProvider.getRegExFlags(annotations);
            return new PatternConverter(flags);
        }
        return null;
    }

    private static int getRegExFlags(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != RegExFlags.class) continue;
            return ((RegExFlags)annotation).value();
        }
        return 0;
    }

    private static class PatternConverter
    implements ParamConverter<Pattern> {
        private final int flags;

        private PatternConverter(int flags) {
            this.flags = flags;
        }

        public Pattern fromString(String patternString) {
            if (StringUtils.isEmpty((String)patternString)) {
                return null;
            }
            try {
                return Pattern.compile(patternString, this.flags);
            }
            catch (PatternSyntaxException e) {
                throw new BadRequestException("Invalid regex '" + patternString + "': " + e.getMessage(), (Throwable)e);
            }
        }

        public String toString(Pattern pattern) {
            if (pattern == null) {
                return null;
            }
            return pattern.toString();
        }
    }
}

