/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.ResourceException;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.commons.string.StringUtils;

public class Resource
implements Comparable<Resource> {
    private static final char RESOURCE_EXTENSION_SEPARATOR = '.';
    private final Class<?> contextClass;
    private final String path;
    private final URL url;

    public static Resource of(Class<?> contextClass, String path) {
        return Resource.asOptional(contextClass, path).orElseThrow(() -> new AssertionError((Object)(Resource.getAbsolutePath(contextClass, path) + " does not exist!")));
    }

    public static Resource of(Class<?> contextClass, String path, URL resourceUrl) {
        return new Resource(contextClass, path, resourceUrl);
    }

    public static Optional<Resource> asOptional(Class<?> contextClass, String path) {
        URL resourceUrl = contextClass.getResource(path);
        if (resourceUrl == null) {
            return Optional.empty();
        }
        return Optional.of(new Resource(contextClass, path, resourceUrl));
    }

    public static String getAbsolutePath(Class<?> contextClass, String path) {
        if (path.startsWith(String.valueOf('/'))) {
            return path.substring(1);
        }
        return ResourceUtils.getPackageResourcePath(contextClass) + "/" + path;
    }

    public static boolean exists(Class<?> contextClass, String path) {
        return contextClass.getResource(path) != null;
    }

    private Resource(Class<?> contextClass, String path, URL url) {
        this.path = path;
        this.contextClass = contextClass;
        this.url = url;
    }

    public String getName() {
        return FileSystemUtils.getLastPathSegment(this.getPath());
    }

    public String getBaseName() {
        return StringUtils.removeLastPart(this.getName(), '.');
    }

    public String getExtension() {
        return StringUtils.getLastPart(this.getName(), '.');
    }

    public boolean hasExtension(String ... extensions) {
        return Arrays.stream(extensions).anyMatch(extension -> this.getName().endsWith("." + extension));
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    public String getPath() {
        return this.path;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getParentPath() {
        return StringUtils.stripSuffix(this.getPath(), this.getName());
    }

    public String getAbsolutePath() {
        return Resource.getAbsolutePath(this.contextClass, this.path);
    }

    public String getPathSegmentAt(int index) {
        String[] pathSegments = FileSystemUtils.getPathSegments(this.path);
        if (index < 0) {
            return pathSegments[pathSegments.length + index];
        }
        return pathSegments[index];
    }

    public InputStream getAsStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw ResourceException.newLoadFailed(this, e);
        }
    }

    public byte[] getAsByteArray() {
        byte[] byArray;
        block8: {
            InputStream inputStream = this.getAsStream();
            try {
                byArray = FileSystemUtils.readStreamBinary(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ResourceException.newLoadFailed(this, e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public SeekableByteChannel getAsChannel() {
        try {
            return Files.newByteChannel(Paths.get(this.url.toURI()), StandardOpenOption.READ);
        }
        catch (Exception e) {
            return new SeekableInMemoryByteChannel(this.getAsByteArray());
        }
    }

    public String getContentAsRawString() {
        String string;
        block8: {
            InputStream inputStream = this.getAsStream();
            try {
                string = FileSystemUtils.readStreamUTF8(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ResourceException.newLoadFailed(this, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public String getContent() {
        return StringUtils.normalizeLineSeparatorsPlatformIndependent(this.getContentAsRawString());
    }

    public List<String> getLines() {
        return StringUtils.splitLinesAsList(this.getContentAsRawString());
    }

    public File getAsTmpFile() throws IOException {
        File tempFile = File.createTempFile("test-data-", this.getName());
        this.copyTo(tempFile);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public File copyTo(File file) throws IOException {
        FileSystemUtils.ensureParentDirectoryExists(file);
        try (FileOutputStream output = new FileOutputStream(file);
             InputStream input = this.getAsStream();){
            FileSystemUtils.copy(input, output);
        }
        return file;
    }

    public void unzipTo(File tempDir) throws IOException {
        try (InputStream inputStream = this.getAsStream();){
            FileSystemUtils.unzip(inputStream, tempDir);
        }
    }

    @Override
    public int compareTo(Resource other) {
        return this.getAbsolutePath().compareTo(other.getAbsolutePath());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.getAbsolutePath().equals(resource.getAbsolutePath()) && this.url.equals(resource.url);
    }

    public int hashCode() {
        return Objects.hash(this.getAbsolutePath(), this.url);
    }
}

