/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S6600")
public class ConstructWithParenthesesCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove the parentheses from this \"%s\" call.";
    private static final Set<String> CONSTRUCT_FUNCTION = Set.of("echo", "clone", "include", "include_once", "require", "require_once", "print");

    @Override
    public void visitCaseClause(CaseClauseTree tree) {
        this.raiseIssueOnParenthesizedExpression(tree.expression(), tree.caseToken(), tree.caseSeparatorToken(), "case");
        super.visitCaseClause(tree);
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.raiseIssueOnParenthesizedExpression(tree.argument(), tree, "break");
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.raiseIssueOnParenthesizedExpression(tree.expression(), tree, "return");
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.raiseIssueOnParenthesizedExpression(tree.expression(), tree, "throw");
        super.visitThrowStatement(tree);
    }

    @Override
    public void visitYieldExpression(YieldExpressionTree tree) {
        String constructName = tree.fromToken() != null ? "yield from" : "yield";
        ExpressionTree elementToCheck = tree.key() != null ? tree.key() : tree.value();
        this.raiseIssueOnParenthesizedExpression(elementToCheck, tree, constructName);
        super.visitYieldExpression(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.raiseIssueOnParenthesizedExpression(tree.argument(), tree, "continue");
        super.visitContinueStatement(tree);
    }

    private void raiseIssueOnParenthesizedExpression(@Nullable ExpressionTree expression, Tree raiseIssueOn, String constructName) {
        if (ConstructWithParenthesesCheck.isParenthesizedExpression(expression)) {
            this.newIssue(raiseIssueOn, String.format(MESSAGE, constructName));
        }
    }

    private void raiseIssueOnParenthesizedExpression(@Nullable ExpressionTree expression, Tree raiseIssueOnStart, Tree raiseIssueOnEnd, String constructName) {
        if (ConstructWithParenthesesCheck.isParenthesizedExpression(expression)) {
            this.context().newIssue(this, raiseIssueOnStart, raiseIssueOnEnd, String.format(MESSAGE, constructName));
        }
    }

    private static boolean isParenthesizedExpression(@Nullable ExpressionTree expression) {
        return expression != null && expression.is(Tree.Kind.PARENTHESISED_EXPRESSION);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String calleeName = ConstructWithParenthesesCheck.getCalleeName(tree.callee());
        if (ConstructWithParenthesesCheck.isConstructFunction(calleeName) && ConstructWithParenthesesCheck.hasParenthesizedArgument(tree)) {
            this.newIssue(tree, String.format(MESSAGE, calleeName));
        }
        super.visitFunctionCall(tree);
    }

    private static boolean hasParenthesizedArgument(FunctionCallTree tree) {
        return tree.callArguments().size() == 1 && ConstructWithParenthesesCheck.isParenthesized(((CallArgumentTree)tree.callArguments().get(0)).value());
    }

    private static boolean isParenthesized(ExpressionTree argument) {
        BinaryExpressionTree binaryExpression;
        return argument.is(Tree.Kind.PARENTHESISED_EXPRESSION) || argument instanceof BinaryExpressionTree && !ConstructWithParenthesesCheck.isExcludedBinaryExpression(binaryExpression = (BinaryExpressionTree)argument) && ConstructWithParenthesesCheck.isParenthesized(binaryExpression.leftOperand());
    }

    private static boolean isExcludedBinaryExpression(BinaryExpressionTree binaryExpression) {
        return binaryExpression.is(Tree.Kind.CONCATENATION, Tree.Kind.POWER, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT);
    }

    private static boolean isConstructFunction(@Nullable String constructName) {
        return constructName != null && CONSTRUCT_FUNCTION.contains(constructName);
    }

    @CheckForNull
    private static String getCalleeName(ExpressionTree callee) {
        return Optional.of(callee).filter(cal -> cal.is(Tree.Kind.NAMESPACE_NAME)).map(cal -> ((NamespaceNameTree)cal).qualifiedName().toLowerCase(Locale.ROOT)).orElse(null);
    }
}

