/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.declaration.ClassNamespaceNameTreeImpl;
import org.sonar.php.tree.impl.expression.MemberAccessTreeImpl;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S2755")
public class XxeCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Disable access to external entities in XML parsing.";
    private static final String SECONDARY_MESSAGE = "This value enables external entities in XML parsing.";
    private static final String PROPAGATED_MESSAGE = "Propagated settings.";
    private static final String OPTIONS = "options";
    private static final Tree.Kind[] ARRAY = new Tree.Kind[]{Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION};

    @Override
    public void visitFunctionCall(FunctionCallTree call) {
        String functionName = CheckUtils.lowerCaseFunctionName(call);
        ExpressionTree callee = call.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME) && "simplexml_load_string".equals(functionName)) {
            CheckUtils.argument(call, OPTIONS, 2).ifPresent(options -> this.checkSimpleXmlOption(options.value(), (Tree)options));
        } else if (callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            if ("load".equals(functionName) || "loadxml".equals(functionName)) {
                CheckUtils.argument(call, OPTIONS, 1).ifPresent(options -> this.checkSimpleXmlOption(options.value(), (Tree)options));
            } else if ("setparserproperty".equals(functionName)) {
                this.checkSetParserProperty(call);
            }
        } else if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS) && "build".equals(functionName) && XxeCheck.isNamespaceMemberEqualTo("Cake\\Utility\\Xml", callee)) {
            CheckUtils.argument(call, OPTIONS, 1).ifPresent(options -> this.checkXmlBuildOption(options.value(), (Tree)options));
        }
        super.visitFunctionCall(call);
    }

    private void checkSimpleXmlOption(ExpressionTree optionValue, Tree treeToReport) {
        if (optionValue.is(Tree.Kind.NAMESPACE_NAME) && "LIBXML_NOENT".equals(((NamespaceNameTree)optionValue).unqualifiedName())) {
            this.createIssue(treeToReport);
        } else if (optionValue.is(Tree.Kind.BITWISE_OR)) {
            BinaryExpressionTree orExpression = (BinaryExpressionTree)optionValue;
            this.checkSimpleXmlOption(orExpression.leftOperand(), treeToReport);
            this.checkSimpleXmlOption(orExpression.rightOperand(), treeToReport);
        } else if (optionValue.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            this.checkSimpleXmlOption(((ParenthesisedExpressionTree)optionValue).expression(), treeToReport);
        } else if (optionValue.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            CheckUtils.uniqueAssignedValue((VariableIdentifierTree)optionValue).ifPresent(x -> this.checkSimpleXmlOption((ExpressionTree)x, treeToReport));
        }
    }

    private void checkSetParserProperty(FunctionCallTree call) {
        Optional<CallArgumentTree> value;
        Optional<CallArgumentTree> property = CheckUtils.argument(call, "property", 0);
        if (property.isPresent() && "XMLReader::SUBST_ENTITIES".equalsIgnoreCase(CheckUtils.nameOf(property.get().value())) && (value = CheckUtils.argument(call, "value", 1)).isPresent() && CheckUtils.isTrueValue(value.get().value())) {
            this.createIssue(call);
        }
    }

    private void checkXmlBuildOption(ExpressionTree optionValue, Tree optionArgument) {
        if (optionValue.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            CheckUtils.uniqueAssignedValue((VariableIdentifierTree)optionValue).filter(uniqueValue -> !uniqueValue.toString().equals(optionArgument.toString())).ifPresent(assignedValue -> this.checkXmlBuildOption((ExpressionTree)assignedValue, optionArgument));
        } else if (optionValue.is(ARRAY)) {
            CheckUtils.arrayValue((ArrayInitializerTree)optionValue, "loadEntities").ifPresent(loadEntitiesValue -> this.raiseIssueIfTrue((ExpressionTree)loadEntitiesValue, optionArgument));
        }
    }

    private void raiseIssueIfTrue(ExpressionTree value, Tree treeToReport) {
        ExpressionTree assignedValue = CheckUtils.assignedValue(value);
        ArrayList<ExpressionTree> secondaryTrees = new ArrayList<ExpressionTree>();
        while (assignedValue.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            secondaryTrees.add(assignedValue);
            assignedValue = CheckUtils.assignedValue(assignedValue);
        }
        if (!CheckUtils.isFalseValue(assignedValue)) {
            PreciseIssue issue = this.createIssue(treeToReport);
            issue.secondary(assignedValue, SECONDARY_MESSAGE);
            secondaryTrees.forEach(tree -> issue.secondary((Tree)tree, PROPAGATED_MESSAGE));
        }
    }

    private PreciseIssue createIssue(Tree tree) {
        return this.context().newIssue(this, tree, MESSAGE);
    }

    private static Optional<String> namespaceMemberFullQualifiedName(ExpressionTree callee) {
        return Optional.of(callee).filter(MemberAccessTreeImpl.class::isInstance).map(c -> ((MemberAccessTreeImpl)c).object()).filter(ClassNamespaceNameTreeImpl.class::isInstance).map(ClassNamespaceNameTreeImpl.class::cast).map(c -> c.symbol().qualifiedName().toString());
    }

    private static boolean isNamespaceMemberEqualTo(String targetNamespace, ExpressionTree callee) {
        return XxeCheck.namespaceMemberFullQualifiedName(callee).filter(name -> targetNamespace.equalsIgnoreCase((String)name) || XxeCheck.isNameInNamespaceEqualTo(targetNamespace, callee, name)).isPresent();
    }

    private static boolean isNameInNamespaceEqualTo(String targetNamespace, ExpressionTree callee, String name) {
        return Optional.ofNullable((NamespaceStatementTree)TreeUtils.findAncestorWithKind((Tree)callee, Collections.singletonList(Tree.Kind.NAMESPACE_STATEMENT))).map(NamespaceStatementTree::namespaceName).filter(nsName -> (nsName.fullName() + "\\" + targetNamespace).equalsIgnoreCase(name)).isPresent();
    }
}

