/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.EndOfCapturingGroupState;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

public class ImpossibleBackReferenceFinder
extends RegexBaseVisitor {
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private Set<BackReferenceTree> impossibleBackReferences = new LinkedHashSet<BackReferenceTree>();
    private Map<String, CapturingGroupTree> capturingGroups = new HashMap<String, CapturingGroupTree>();

    public ImpossibleBackReferenceFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitBackReference(BackReferenceTree tree) {
        if (!this.capturingGroups.containsKey(tree.groupName())) {
            this.impossibleBackReferences.add(tree);
        }
    }

    @Override
    public void visitCapturingGroup(CapturingGroupTree group) {
        super.visitCapturingGroup(group);
        this.addGroup(group);
    }

    private void addGroup(CapturingGroupTree group) {
        this.capturingGroups.put("" + group.getGroupNumber(), group);
        group.getName().ifPresent(name -> this.capturingGroups.put((String)name, group));
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        Map<String, CapturingGroupTree> originalCapturingGroups = this.capturingGroups;
        HashMap<String, CapturingGroupTree> allCapturingGroups = new HashMap<String, CapturingGroupTree>();
        for (RegexTree alternative : tree.getAlternatives()) {
            this.capturingGroups = new HashMap<String, CapturingGroupTree>(originalCapturingGroups);
            this.visit(alternative);
            allCapturingGroups.putAll(this.capturingGroups);
        }
        this.capturingGroups = allCapturingGroups;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        Integer maximumRepetitions = tree.getQuantifier().getMaximumRepetitions();
        if (maximumRepetitions != null && maximumRepetitions < 2) {
            super.visitRepetition(tree);
            return;
        }
        Set<BackReferenceTree> originalImpossibleBackReferences = this.impossibleBackReferences;
        this.impossibleBackReferences = new LinkedHashSet<BackReferenceTree>();
        HashMap<String, CapturingGroupTree> originalCapturingGroups = new HashMap<String, CapturingGroupTree>(this.capturingGroups);
        super.visitRepetition(tree);
        if (!this.impossibleBackReferences.isEmpty()) {
            this.capturingGroups = originalCapturingGroups;
            this.findReachableGroups(tree.getElement(), tree.continuation(), this.impossibleBackReferences, new HashSet<AutomatonState>());
            this.impossibleBackReferences = originalImpossibleBackReferences;
            super.visitRepetition(tree);
        }
    }

    private void findReachableGroups(AutomatonState start, AutomatonState stop, Set<BackReferenceTree> preliminaryImpossibleReferences, Set<AutomatonState> visited) {
        if (start == stop || start instanceof BackReferenceTree && preliminaryImpossibleReferences.contains(start) || visited.contains(start)) {
            return;
        }
        visited.add(start);
        if (start instanceof EndOfCapturingGroupState) {
            this.addGroup(((EndOfCapturingGroupState)start).group());
        }
        for (AutomatonState automatonState : start.successors()) {
            this.findReachableGroups(automatonState, stop, preliminaryImpossibleReferences, visited);
        }
    }

    @Override
    protected void after(RegexParseResult regexParseResult) {
        for (BackReferenceTree backReference : this.impossibleBackReferences) {
            String message;
            ArrayList<RegexIssueLocation> secondaries = new ArrayList<RegexIssueLocation>();
            if (this.capturingGroups.containsKey(backReference.groupName())) {
                message = "Fix this backreference, so that it refers to a group that can be matched before it.";
                CapturingGroupTree group = this.capturingGroups.get(backReference.groupName());
                secondaries.add(new RegexIssueLocation(group, "This group is used in a backreference before it is defined"));
            } else {
                message = "Fix this backreference - it refers to a capturing group that doesn't exist.";
            }
            this.regexElementIssueReporter.report(backReference, message, null, secondaries);
        }
    }
}

