/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PartitionIndexUtils {
    public static final String PARTITION_LIST_KEY = "#-#partition-list#-#";
    public static final String MERGED_PARTITIONS_LIST_KEY = "#-#partitions-with-merges#-#";

    public static void addStoredPartitions(ConvenientStore store, Set<String> partitionsToAdd) throws StorageException {
        PartitionIndexUtils.addStoredPartitions(store, partitionsToAdd, PARTITION_LIST_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> addStoredPartitions(ConvenientStore store, Collection<String> partitionsToAdd, String key) throws StorageException {
        Lock lock = store.obtainLock(key);
        lock.lock();
        try {
            HashSet<String> partitions = new HashSet<String>(PartitionIndexUtils.getStoredPartitions(store, key));
            if (partitions.addAll(partitionsToAdd)) {
                store.putWithString(key, StorageUtils.serialize(CollectionUtils.sort(partitions)));
            }
            HashSet<String> hashSet = partitions;
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMergedPathsOfPartition(ConvenientStore store, String partition, Collection<String> paths, StorageStringAbbreviator abbreviator, ParentedCommitDescriptor mergeCommit) throws StorageException {
        if (!paths.isEmpty()) {
            PartitionIndexUtils.addStoredPartitions(store, List.of(partition), MERGED_PARTITIONS_LIST_KEY);
        }
        String keyPrefix = PartitionIndexUtils.makeMergedPartitionEntriesKey(partition);
        Lock lock = store.obtainLock(keyPrefix + mergeCommit.toString());
        lock.lock();
        try {
            Set storedPaths = Set.copyOf(PartitionIndexUtils.getMergedPathsOfPartition(store, Set.of(partition), abbreviator).getSecondList());
            Sets.SetView mergedPaths = Sets.union(Set.copyOf(paths), storedPaths);
            List mergedPathsAbbreviated = CollectionUtils.sort((Collection)CollectionUtils.mapWithException((Collection)mergedPaths, abbreviator::abbreviate), Integer::compareTo);
            store.putWithString(keyPrefix, ByteArrayUtils.serializeIntegerList((List)mergedPathsAbbreviated));
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeAllMergedPathsOfPartition(ConvenientStore store, Collection<String> partitions) throws StorageException {
        Lock lock = store.obtainLock(MERGED_PARTITIONS_LIST_KEY);
        lock.lock();
        try {
            store.removeWithStrings(partitions.stream().map(PartitionIndexUtils::makeMergedPartitionEntriesKey).toList());
            PartitionIndexUtils.removeStorePartitions(store, partitions, MERGED_PARTITIONS_LIST_KEY);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PairList<String, String> getMergedPathsOfPartition(ConvenientStore store, Set<String> partitions, StorageStringAbbreviator abbreviator) throws StorageException {
        PairList result = new PairList();
        Lock lock = store.obtainLock(MERGED_PARTITIONS_LIST_KEY);
        lock.lock();
        try {
            List<String> keys = partitions.stream().map(PartitionIndexUtils::makeMergedPartitionEntriesKey).toList();
            CollectionUtils.forEachWithException(partitions, store.getWithStrings(keys), (partition, abbreviatedPaths) -> {
                if (abbreviatedPaths == null) {
                    return;
                }
                result.addAll(partition, (Iterable)CollectionUtils.mapWithException((Collection)ByteArrayUtils.deserializeIntegerList((byte[])abbreviatedPaths), abbreviator::unabbreviate));
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private static String makeMergedPartitionEntriesKey(String partition) {
        return MERGED_PARTITIONS_LIST_KEY + partition + "#";
    }

    public static String extractPartitionFromPartitionedMetaKey(String key) {
        return key.substring(MERGED_PARTITIONS_LIST_KEY.length(), key.length() - 1);
    }

    public static List<String> getStoredPartitions(ConvenientStore store) throws StorageException {
        return PartitionIndexUtils.getStoredPartitions(store, PARTITION_LIST_KEY);
    }

    public static List<String> getStoredPartitions(ConvenientStore store, String key) throws StorageException {
        List partitions = (List)StorageUtils.deserialize(store.getWithString(key));
        if (partitions == null) {
            return new ArrayList<String>();
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeStorePartitions(ConvenientStore store, Collection<String> partitions, String key) throws StorageException {
        if (partitions.isEmpty()) {
            return;
        }
        Lock lock = store.obtainLock(key);
        lock.lock();
        try {
            List<String> stored = PartitionIndexUtils.getStoredPartitions(store, key);
            stored.removeAll(partitions);
            store.putWithString(key, StorageUtils.serialize(CollectionUtils.sort(stored)));
        }
        finally {
            lock.unlock();
        }
    }

    private PartitionIndexUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

