/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.List;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ConvenientStore
extends DelegatingStore {
    private final StorageStringAbbreviator abbreviator;
    private final boolean abbreviateKeys;

    public ConvenientStore(IStore store) {
        this(store, true);
    }

    public ConvenientStore(IStore store, boolean autoAbbreviateKeys) {
        super(store);
        this.abbreviator = StorageUtils.getAbbreviatorFromStore(store);
        this.abbreviateKeys = autoAbbreviateKeys && this.abbreviator != null;
    }

    public byte @Nullable [] getWithString(@NonNull String key) throws StorageException {
        return this.store.get(this.convertKey(key));
    }

    public List<byte @Nullable []> getWithStrings(List<@NonNull String> keys) throws StorageException {
        return this.store.get(this.convertKeys(keys));
    }

    public void putWithString(@NonNull String key, byte @NonNull [] value) throws StorageException {
        this.store.put(this.convertKey(key), value);
    }

    public void putWithStrings(PairList<@NonNull String, byte @NonNull []> keysValues) throws StorageException {
        List<byte[]> keys = this.convertKeys(keysValues.extractFirstList());
        PairList byteKeysValues = new PairList(keysValues.size());
        for (int i = 0; i < keysValues.size(); ++i) {
            byteKeysValues.add((Object)keys.get(i), (Object)((byte[])keysValues.getSecond(i)));
        }
        this.store.put((PairList<byte[], byte[]>)byteKeysValues);
    }

    public void removeWithString(@NonNull String key) throws StorageException {
        this.store.remove(this.convertKey(key));
    }

    public void removeWithStrings(List<@NonNull String> keys) throws StorageException {
        this.store.remove(this.convertKeys(keys));
    }

    public void removeByPrefix(@NonNull String prefix) throws StorageException {
        this.failIfAbbreviated();
        this.store.removeByPrefix(StringUtils.stringToBytes((String)prefix));
    }

    public void scan(@NonNull String prefix, IKeyValueCallback callback) throws StorageException {
        this.failIfAbbreviated();
        this.store.scan(StringUtils.stringToBytes((String)prefix), callback);
    }

    public void scanKeys(@NonNull String prefix, IKeyValueCallback callback) throws StorageException {
        this.failIfAbbreviated();
        this.store.scanKeys(StringUtils.stringToBytes((String)prefix), callback);
    }

    public PairList<byte[], byte[]> getEntriesStartingWith(String prefix) throws StorageException {
        this.failIfAbbreviated();
        PairList result = new PairList();
        this.scan(prefix, (byte[] first, byte[] second) -> {
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)first, (Object)second);
            }
        });
        return result;
    }

    public PairList<byte[], byte[]> getEntriesStartingWith(byte[] prefix) throws StorageException {
        PairList result = new PairList();
        this.scan(prefix, (byte[] first, byte[] second) -> {
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)first, (Object)second);
            }
        });
        return result;
    }

    public <K, V> PairList<K, V> getEntriesStartingWith(List<byte[]> prefixes, FunctionWithException<byte[], K, StorageException> keyConverter, FunctionWithException<byte[], V, StorageException> valueConverter) throws StorageException {
        PairList result = new PairList();
        this.scanEntriesStartingWith(prefixes, (BiConsumerWithException<byte[], byte[], StorageException>)((BiConsumerWithException)(k, v) -> result.add(keyConverter.apply(k), valueConverter.apply(v))));
        return result;
    }

    public void scanEntriesStartingWith(List<byte[]> prefixes, final BiConsumerWithException<byte[], byte[], StorageException> consumer) throws StorageException {
        ExceptionHandlingKeyValueCallbackBase exceptionHandlingCallback = new ExceptionHandlingKeyValueCallbackBase(this){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                consumer.accept((Object)key, (Object)value);
            }
        };
        this.scan(prefixes, (IKeyValueCallback)exceptionHandlingCallback);
        exceptionHandlingCallback.throwCaughtException();
    }

    @Deprecated
    public StorageStringAbbreviator getAbbreviator() throws StorageException {
        if (this.abbreviator == null) {
            throw new StorageException("Index was created without abbreviation support, hence abbreviator is not available!");
        }
        return this.abbreviator;
    }

    public boolean hasAbbreviatedKeys() {
        return this.abbreviator != null;
    }

    private void failIfAbbreviated() throws StorageException {
        if (this.abbreviator != null) {
            throw new StorageException("Can not use string-based prefix scanning in abbreviation mode. Please use the byte[] based methods.");
        }
    }

    private byte[] convertKey(String key) throws StorageException {
        if (this.abbreviateKeys) {
            return ByteArrayUtils.intToByteArray((int)this.abbreviator.abbreviate(key));
        }
        return StringUtils.stringToBytes((String)key);
    }

    private List<byte[]> convertKeys(List<@NonNull String> keys) throws StorageException {
        if (this.abbreviateKeys) {
            return CollectionUtils.map(this.abbreviator.abbreviate(keys), ByteArrayUtils::intToByteArray);
        }
        return CollectionUtils.map(keys, StringUtils::stringToBytes);
    }
}

