/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.PolicyContext;
import com.microsoft.tfs.core.checkinpolicies.PolicyDefinition;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationCancelledException;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationStatus;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluatorState;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.checkinpolicies.PolicyInstance;
import com.microsoft.tfs.core.checkinpolicies.PolicyLoader;
import com.microsoft.tfs.core.checkinpolicies.PolicyLoaderException;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyEvaluatorStateChangedEvent;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyEvaluatorStateChangedListener;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyLoadErrorEvent;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyLoadErrorListener;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedEvent;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedListener;
import com.microsoft.tfs.core.checkinpolicies.internal.LoadErrorPolicy;
import com.microsoft.tfs.core.checkinpolicies.internal.PolicyEvaluationStatusComparator;
import com.microsoft.tfs.core.clients.CoreClientEvent;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.events.AffectedTeamProjectsChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.AffectedTeamProjectsChangedListener;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedPendingChangesChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedPendingChangesChangedListener;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedWorkItemsChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedWorkItemsChangedListener;
import com.microsoft.tfs.core.pendingcheckin.events.CommentChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.CommentChangedListener;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.StandardListenerList;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyEvaluator
implements Closable {
    private static final Log log = LogFactory.getLog(PolicyEvaluator.class);
    private static final PolicyEvaluationStatusComparator policyStatusComparator = new PolicyEvaluationStatusComparator();
    private List<PolicyEvaluationStatus> policyEvaluationStatuses = new ArrayList<PolicyEvaluationStatus>();
    private final VersionControlClient client;
    private final PolicyLoader policyLoader;
    private final ListenerList evaluatorStateChangedEventListeners = new StandardListenerList();
    private final ListenerList policyStateChangedEventListeners = new StandardListenerList();
    private final ListenerList policyLoadErrorEventListeners = new StandardListenerList();
    private PendingCheckin pendingCheckin;
    private final Object pendingCheckinLock = new Object();
    private final Object evaluatorLock = new Object();
    private final PolicyStateChangedListener savedPolicyStateChangedEventListener = new PolicyStateChangedListener(){

        @Override
        public void onPolicyStateChanged(PolicyStateChangedEvent e) {
            PolicyEvaluator.this.onPolicyStateChanged(e);
        }
    };
    private final CheckedPendingChangesChangedListener savedCheckedPendingChangesChangedListener = new CheckedPendingChangesChangedListener(){

        @Override
        public void onCheckedPendingChangesChanged(CheckedPendingChangesChangedEvent e) {
            PolicyEvaluator.this.onPolicyEvaluatorStateChanged(e);
        }
    };
    private final AffectedTeamProjectsChangedListener savedAffectedTeamProjectsChangedListener = new AffectedTeamProjectsChangedListener(){

        @Override
        public void onAffectedTeamProjectsChanged(AffectedTeamProjectsChangedEvent e) {
            PolicyEvaluator.this.onPolicyEvaluatorStateChanged(e);
        }
    };
    private final CommentChangedListener savedCommentChangedListener = new CommentChangedListener(){

        @Override
        public void onCommentChanged(CommentChangedEvent e) {
            PolicyEvaluator.this.onPolicyEvaluatorStateChanged(e);
        }
    };
    private final CheckedWorkItemsChangedListener savedWorkItemsChagnedListener = new CheckedWorkItemsChangedListener(){

        @Override
        public void onCheckedWorkItemsChangesChanged(CheckedWorkItemsChangedEvent e) {
            PolicyEvaluator.this.onPolicyEvaluatorStateChanged(e);
        }
    };
    private PolicyEvaluatorState evaluatorState = PolicyEvaluatorState.UNEVALUATED;

    public PolicyEvaluator(VersionControlClient client, PolicyLoader policyLoader) {
        Check.notNull(client, "client");
        Check.notNull(policyLoader, "policyLoader");
        this.client = client;
        this.policyLoader = policyLoader;
    }

    public void addPolicyEvaluatorStateChangedListener(PolicyEvaluatorStateChangedListener listener) {
        this.evaluatorStateChangedEventListeners.addListener(listener);
    }

    public void removePolicyEvaluatorStateChangedListener(PolicyEvaluatorStateChangedListener listener) {
        this.evaluatorStateChangedEventListeners.removeListener(listener);
    }

    private void firePolicyEvaluatorStateChangedEvent() {
        final PolicyEvaluator evaluator = this;
        this.evaluatorStateChangedEventListeners.foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PolicyEvaluatorStateChangedListener)listener).onPolicyEvaluatorStateChanged(new PolicyEvaluatorStateChangedEvent(EventSource.newFromHere(), evaluator));
                return true;
            }
        });
    }

    public void addPolicyStateChangedListener(PolicyStateChangedListener listener) {
        this.policyStateChangedEventListeners.addListener(listener);
    }

    public void removePolicyStateChangedListener(PolicyStateChangedListener listener) {
        this.policyStateChangedEventListeners.removeListener(listener);
    }

    private void firePolicyStateChangedEvent(final PolicyStateChangedEvent event) {
        Check.notNull(event, "event");
        this.policyStateChangedEventListeners.foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PolicyStateChangedListener)listener).onPolicyStateChanged(event);
                return true;
            }
        });
    }

    public void addPolicyLoadErrorListener(PolicyLoadErrorListener listener) {
        this.policyLoadErrorEventListeners.addListener(listener);
    }

    public void removePolicyLoadErrorListener(PolicyLoadErrorListener listener) {
        this.policyLoadErrorEventListeners.removeListener(listener);
    }

    private void firePolicyLoadErrorEvent(final PolicyLoadErrorEvent event) {
        Check.notNull(event, "event");
        this.policyLoadErrorEventListeners.foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PolicyLoadErrorListener)listener).onPolicyLoadError(event);
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingCheckin(PendingCheckin pendingCheckin) {
        Check.notNull(pendingCheckin, "pendingCheckin");
        Object object = this.pendingCheckinLock;
        synchronized (object) {
            this.removePendingCheckinEventListeners();
            this.pendingCheckin = pendingCheckin;
            this.pendingCheckin.getPendingChanges().addAffectedTeamProjectsChangedListener(this.savedAffectedTeamProjectsChangedListener);
            this.pendingCheckin.getPendingChanges().addCheckedPendingChangesChangedListener(this.savedCheckedPendingChangesChangedListener);
            this.pendingCheckin.getPendingChanges().addCommentChangedListener(this.savedCommentChangedListener);
            this.pendingCheckin.getWorkItems().addCheckedWorkItemsChangedListener(this.savedWorkItemsChagnedListener);
        }
        object = this.evaluatorLock;
        synchronized (object) {
            this.evaluatorState = PolicyEvaluatorState.UNEVALUATED;
        }
        this.firePolicyEvaluatorStateChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicies(PolicyContext policyContext) {
        block18: {
            PendingCheckin currentPendingCheckin;
            Check.notNull(policyContext, "policyContext");
            Object object = this.pendingCheckinLock;
            synchronized (object) {
                currentPendingCheckin = this.pendingCheckin;
            }
            List<PolicyEvaluationStatus> oldPolicies = this.policyEvaluationStatuses;
            this.policyEvaluationStatuses = new ArrayList<PolicyEvaluationStatus>();
            this.evaluatorState = PolicyEvaluatorState.UNEVALUATED;
            if (currentPendingCheckin == null) {
                return;
            }
            try {
                int i;
                String[] affectedTeamProjectServerPaths = currentPendingCheckin.getPendingChanges().getAffectedTeamProjectPaths();
                if (affectedTeamProjectServerPaths.length <= 0) break block18;
                PolicyDefinition[] definitions = this.client.getCheckinPoliciesForServerPaths(affectedTeamProjectServerPaths);
                for (i = 0; i < definitions.length; ++i) {
                    int j;
                    PolicyDefinition definition = definitions[i];
                    if (!definition.isEnabled()) continue;
                    int oldPoliciesOriginalSize = oldPolicies.size();
                    for (j = 0; j < oldPolicies.size(); ++j) {
                        PolicyEvaluationStatus oldStatus = oldPolicies.get(j);
                        if (oldStatus.getPolicy() instanceof LoadErrorPolicy || !oldStatus.getPolicyType().equals(definition.getType())) continue;
                        this.policyEvaluationStatuses.add(oldStatus);
                        oldPolicies.remove(j);
                        oldStatus.update(definition.getPriority(), definition.getScopeExpressions(), definition.getConfigurationMemento());
                        break;
                    }
                    if (j != oldPoliciesOriginalSize) continue;
                    PolicyLoader loader = this.getPolicyLoader();
                    PolicyInstance instance = null;
                    try {
                        instance = loader.load(definition.getType().getID());
                        if (instance == null) {
                            log.warn((Object)MessageFormat.format(Messages.getString("PolicyEvaluator.CouldNotLoadImplementationFormat"), definition.getType().toString()));
                            instance = new LoadErrorPolicy(MessageFormat.format(Messages.getString("PolicyEvaluator.NoImplementationFoundFormat"), definition.getType().getID()), definition.getType());
                            this.evaluatorState = PolicyEvaluatorState.POLICIES_LOAD_ERROR;
                        }
                    }
                    catch (PolicyLoaderException e) {
                        log.warn((Object)MessageFormat.format("Exception loading check-in policy {0}", definition.toString()), (Throwable)e);
                        this.evaluatorState = PolicyEvaluatorState.POLICIES_LOAD_ERROR;
                        instance = new LoadErrorPolicy(MessageFormat.format(Messages.getString("PolicyEvaluator.ExceptionLoadingPolicyFormat"), definition.getType().getID(), e.getLocalizedMessage()), definition.getType());
                    }
                    instance.loadConfiguration(definition.getConfigurationMemento());
                    this.policyEvaluationStatuses.add(new PolicyEvaluationStatus(instance, definition.getPriority(), definition.getScopeExpressions()));
                }
                Collections.sort(this.policyEvaluationStatuses, policyStatusComparator);
                for (i = 0; i < this.policyEvaluationStatuses.size(); ++i) {
                    PolicyEvaluationStatus status = this.policyEvaluationStatuses.get(i);
                    try {
                        status.initialize(currentPendingCheckin, policyContext);
                        status.addPolicyStateChangedEventListener(this.savedPolicyStateChangedEventListener);
                        continue;
                    }
                    catch (Exception e) {
                        log.warn((Object)MessageFormat.format("Exception initializing check-in policy {0}", status.getPolicyType().getName()), (Throwable)e);
                        this.evaluatorState = PolicyEvaluatorState.POLICIES_LOAD_ERROR;
                        this.policyEvaluationStatuses.set(i, new PolicyEvaluationStatus(new LoadErrorPolicy(MessageFormat.format(Messages.getString("PolicyEvaluator.ExceptionInitializingPolicyFormat"), status.getPolicyType().getID(), e.getLocalizedMessage()), status.getPolicyType()), status.getPriority(), status.getScopeExpressions()));
                        status.close();
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Generic error loading policies", t);
                this.evaluatorState = PolicyEvaluatorState.POLICIES_LOAD_ERROR;
                this.closePolicyStatuses(this.policyEvaluationStatuses.toArray(new PolicyEvaluationStatus[this.policyEvaluationStatuses.size()]));
                this.policyEvaluationStatuses = new ArrayList<PolicyEvaluationStatus>();
                throw new TECoreException(Messages.getString("PolicyEvaluator.ErrorLoadingCheckinPolicies"), t);
            }
            finally {
                this.closePolicyStatuses(oldPolicies.toArray(new PolicyEvaluationStatus[oldPolicies.size()]));
            }
        }
        if (this.evaluatorState == PolicyEvaluatorState.UNEVALUATED && this.policyEvaluationStatuses.size() == 0) {
            this.evaluatorState = PolicyEvaluatorState.EVALUATED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFailure[] reloadAndEvaluate(PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        Check.notNull(policyContext, "policyContext");
        Object object = this.evaluatorLock;
        synchronized (object) {
            this.evaluatorState = PolicyEvaluatorState.UNEVALUATED;
            return this.evaluate(policyContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.pendingCheckinLock;
        synchronized (object) {
            this.removePendingCheckinEventListeners();
        }
        object = this.evaluatorLock;
        synchronized (object) {
            this.evaluatorStateChangedEventListeners.clear();
            this.closePolicyStatuses(this.policyEvaluationStatuses.toArray(new PolicyEvaluationStatus[this.policyEvaluationStatuses.size()]));
            this.policyEvaluationStatuses.clear();
        }
    }

    private void closePolicyStatuses(PolicyEvaluationStatus[] statuses) {
        Check.notNull(statuses, "statuses");
        for (int i = 0; i < statuses.length; ++i) {
            PolicyEvaluationStatus s = statuses[i];
            if (s == null) continue;
            log.trace((Object)MessageFormat.format("closing status for no-longer-needed policy type {0}", s.getPolicyType().getID()));
            s.removePolicyStateChangedEventListener(this.savedPolicyStateChangedEventListener);
            try {
                s.close();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Error closing policy status, continuing closing others", (Throwable)e);
            }
        }
    }

    private void removePendingCheckinEventListeners() {
        if (this.pendingCheckin != null && this.pendingCheckin.getPendingChanges() != null) {
            this.pendingCheckin.getPendingChanges().removeAffectedTeamProjectsChangedListener(this.savedAffectedTeamProjectsChangedListener);
            this.pendingCheckin.getPendingChanges().removeCheckedPendingChangesChangedListener(this.savedCheckedPendingChangesChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFailure[] evaluate(PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        PolicyFailure[] failures;
        block25: {
            Check.notNull(policyContext, "policyContext");
            log.trace((Object)"evaluate called");
            failures = new PolicyFailure[]{};
            TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
            Throwable loaderThrowable = null;
            try {
                Object object = this.evaluatorLock;
                synchronized (object) {
                    block23: {
                        try {
                            if (this.evaluatorState == PolicyEvaluatorState.UNEVALUATED || this.evaluatorState == PolicyEvaluatorState.POLICIES_LOAD_ERROR || this.evaluatorState == PolicyEvaluatorState.CANCELLED) {
                                try {
                                    this.loadPolicies(policyContext);
                                }
                                catch (Throwable t) {
                                    loaderThrowable = t;
                                }
                            }
                            boolean preserveLoadErrorState = false;
                            if (this.evaluatorState == PolicyEvaluatorState.POLICIES_LOAD_ERROR) {
                                preserveLoadErrorState = true;
                            }
                            taskMonitor.begin(Messages.getString("PolicyEvaluator.EvaluatingCheckinPolicies"), this.policyEvaluationStatuses.size());
                            if (this.policyEvaluationStatuses.size() == 0) {
                                if (!preserveLoadErrorState) {
                                    this.evaluatorState = PolicyEvaluatorState.EVALUATED;
                                }
                                break block23;
                            }
                            for (int i = 0; i < this.policyEvaluationStatuses.size(); ++i) {
                                if (taskMonitor.isCanceled()) {
                                    throw new PolicyEvaluationCancelledException();
                                }
                                PolicyEvaluationStatus status = this.policyEvaluationStatuses.get(i);
                                taskMonitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("PolicyEvaluator.EvaluatingFormat"), status.getPolicyType().getName()));
                                TaskMonitor subTaskMonitor = null;
                                try {
                                    subTaskMonitor = taskMonitor.newSubTaskMonitor(1);
                                    policyContext.addProperty("TASK_MONITOR", subTaskMonitor);
                                    status.evaluate(policyContext);
                                }
                                finally {
                                    if (subTaskMonitor != null) {
                                        subTaskMonitor.done();
                                    }
                                }
                                if (preserveLoadErrorState) continue;
                                this.evaluatorState = PolicyEvaluatorState.EVALUATED;
                            }
                            failures = this.getFailures();
                        }
                        catch (PolicyEvaluationCancelledException e) {
                            this.evaluatorState = PolicyEvaluatorState.CANCELLED;
                            throw e;
                        }
                        catch (Exception e) {
                            log.error((Object)"Unhandled policy evaluation exception", (Throwable)e);
                            this.evaluatorState = PolicyEvaluatorState.POLICIES_LOAD_ERROR;
                            failures = new PolicyFailure[]{};
                            this.firePolicyLoadErrorEvent(new PolicyLoadErrorEvent(EventSource.newFromHere(), this, e));
                        }
                    }
                }
                taskMonitor.done();
                if (loaderThrowable == null) break block25;
                this.firePolicyLoadErrorEvent(new PolicyLoadErrorEvent(EventSource.newFromHere(), this, loaderThrowable));
            }
            catch (Throwable throwable) {
                taskMonitor.done();
                if (loaderThrowable != null) {
                    this.firePolicyLoadErrorEvent(new PolicyLoadErrorEvent(EventSource.newFromHere(), this, loaderThrowable));
                }
                for (int i = 0; i < failures.length; ++i) {
                    PolicyFailure policyFailure = failures[i];
                    if (!(policyFailure.getPolicy() instanceof LoadErrorPolicy)) continue;
                    this.firePolicyLoadErrorEvent(new PolicyLoadErrorEvent(EventSource.newFromHere(), this, new PolicyLoaderException(policyFailure.getMessage(), policyFailure.getPolicy().getPolicyType())));
                }
                this.firePolicyEvaluatorStateChangedEvent();
                throw throwable;
            }
        }
        for (int i = 0; i < failures.length; ++i) {
            PolicyFailure policyFailure = failures[i];
            if (!(policyFailure.getPolicy() instanceof LoadErrorPolicy)) continue;
            this.firePolicyLoadErrorEvent(new PolicyLoadErrorEvent(EventSource.newFromHere(), this, new PolicyLoaderException(policyFailure.getMessage(), policyFailure.getPolicy().getPolicyType())));
        }
        this.firePolicyEvaluatorStateChangedEvent();
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyEvaluatorState getPolicyEvaluatorState() {
        Object object = this.evaluatorLock;
        synchronized (object) {
            return this.evaluatorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPolicyCount() {
        Object object = this.evaluatorLock;
        synchronized (object) {
            return this.policyEvaluationStatuses.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFailure[] getFailures() {
        ArrayList<PolicyFailure> failures = new ArrayList<PolicyFailure>();
        Object object = this.evaluatorLock;
        synchronized (object) {
            for (PolicyEvaluationStatus status : this.policyEvaluationStatuses) {
                PolicyFailure[] theseFailures = status.getFailures();
                if (theseFailures == null) continue;
                for (int j = 0; j < theseFailures.length; ++j) {
                    failures.add(theseFailures[j]);
                }
            }
        }
        return failures.toArray(new PolicyFailure[failures.size()]);
    }

    public PolicyLoader getPolicyLoader() {
        return this.policyLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPolicyEvaluatorStateChanged(CoreClientEvent e) {
        Object object = this.evaluatorLock;
        synchronized (object) {
            this.evaluatorState = PolicyEvaluatorState.UNEVALUATED;
        }
        this.firePolicyEvaluatorStateChangedEvent();
    }

    private void onPolicyStateChanged(PolicyStateChangedEvent e) {
        this.firePolicyStateChangedEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingCheckin getPendingCheckin() {
        Object object = this.pendingCheckinLock;
        synchronized (object) {
            return this.pendingCheckin;
        }
    }

    public static String makeTextErrorForLoadException(Throwable throwable) {
        Check.notNull(throwable, "throwable");
        StringBuffer sb = new StringBuffer();
        if (throwable instanceof PolicyLoaderException && ((PolicyLoaderException)throwable).getPolicyType() != null) {
            sb.append(Messages.getString("PolicyEvaluator.RequiredCheckinPolicyFailedToLoad"));
            PolicyLoaderException ple = (PolicyLoaderException)throwable;
            sb.append(Messages.getString("PolicyEvaluator.NameColon") + ple.getPolicyType().getName() + "\n");
            sb.append(Messages.getString("PolicyEvaluator.IDColon") + ple.getPolicyType().getID() + "\n");
            sb.append(Messages.getString("PolicyEvaluator.InstallationInstructionsColon") + ple.getPolicyType().getInstallationInstructions() + "\n");
            sb.append(Messages.getString("PolicyEvaluator.ErrorColon") + throwable.getLocalizedMessage() + "\n\n");
        } else {
            sb.append(Messages.getString("PolicyEvaluator.AnErrorOccurredInThePolicyFramework"));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            pw.flush();
            sw.flush();
            sb.append(Messages.getString("PolicyEvaluator.ErrorColon") + sw.toString() + "\n");
        }
        sb.append(Messages.getString("PolicyEvaluator.MoreDetailsMayBeAvailableInPlatformLogs"));
        return sb.toString();
    }
}

