/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.reporting;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingConfigurationEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingServerEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.reporting.internal.ReportingConstants;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.URLEncode;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReportUtils {
    private static final Log log = LogFactory.getLog(ReportUtils.class);

    private ReportUtils() {
    }

    public static boolean isReportingConfigured(TFSTeamProjectCollection connection) {
        Check.notNull(connection, "connection");
        ProjectCollectionEntity projectCollection = connection.getTeamProjectCollectionEntity(false);
        if (projectCollection != null) {
            ReportingFolderEntity reportingFolder = projectCollection.getReportingFolder();
            ReportingConfigurationEntity reportingConfiguration = projectCollection.getReportingConfiguration();
            if (reportingFolder != null && reportingConfiguration != null && reportingConfiguration.getReportingServer() != null) {
                return true;
            }
        }
        return false;
    }

    public static String getReportManagerURL(TFSTeamProjectCollection connection) {
        ReportingConfigurationEntity reportingConfiguration;
        ProjectCollectionEntity projectCollection;
        Check.notNull(connection, "connection");
        if (ReportUtils.isReportingConfigured(connection) && (projectCollection = connection.getTeamProjectCollectionEntity(false)) != null && (reportingConfiguration = projectCollection.getReportingConfiguration()) != null) {
            return reportingConfiguration.getReportingServer().getReportManagerURL();
        }
        return null;
    }

    public static String getReportServiceURL(TFSTeamProjectCollection connection) {
        ReportingServerEntity reportingServer;
        String baseUri;
        ProjectCollectionEntity projectCollection;
        Check.notNull(connection, "connection");
        if (ReportUtils.isReportingConfigured(connection) && (projectCollection = connection.getTeamProjectCollectionEntity(false)) != null && (baseUri = (reportingServer = projectCollection.getReportingFolder().getReportingServer()).getReportWebServiceURL()) != null) {
            return URIUtils.combinePaths(baseUri, "ReportService2005.asmx", false);
        }
        return null;
    }

    public static String formatReportManagerPath(String reportManagerUrl, String itemPath) {
        Check.notNull(reportManagerUrl, "reportManagerUrl");
        Check.notNull(itemPath, "itemPath");
        if (!itemPath.startsWith("/")) {
            itemPath = "/" + itemPath;
        }
        return MessageFormat.format("{0}/Pages/Folder.aspx?ItemPath={1}", reportManagerUrl, URLEncode.encode(itemPath));
    }

    public static String formatReportViewerPath(String reportViewerUrl, String itemPath, boolean showToolbar) {
        reportViewerUrl = ReportUtils.removeKnownWebServerPaths(reportViewerUrl);
        while (reportViewerUrl.endsWith("/")) {
            reportViewerUrl = reportViewerUrl.substring(0, reportViewerUrl.length() - 1);
        }
        if (!itemPath.startsWith("/")) {
            itemPath = "/" + itemPath;
        }
        String hideToolbarString = MessageFormat.format("&{0}=false", URLEncode.encode("rc:Toolbar"));
        return MessageFormat.format("{0}?{1}{2}", reportViewerUrl, URLEncode.encode(itemPath), showToolbar ? "" : hideToolbarString);
    }

    public static String removeKnownWebServerPaths(String url) {
        Check.notNull(url, "url");
        url = url.trim();
        for (int i = 0; i < ReportingConstants.KNOWN_WEB_SERVICE_PATHS.length; ++i) {
            if (!url.endsWith(ReportingConstants.KNOWN_WEB_SERVICE_PATHS[i])) continue;
            url = url.substring(0, url.length() - ReportingConstants.KNOWN_WEB_SERVICE_PATHS[i].length());
        }
        return url;
    }

    public static String getProjectReportFolder(TFSTeamProjectCollection connection, GUID projectId) {
        ProjectCollectionEntity projectCollection;
        if (ReportUtils.isReportingConfigured(connection) && (projectCollection = connection.getTeamProjectCollectionEntity(false)) != null) {
            TeamProjectEntity teamProject = projectCollection.getTeamProject(projectId);
            if (teamProject == null) {
                log.warn((Object)MessageFormat.format("Could not load team project configuration data for {0}", projectId));
            } else if (teamProject.getReportingFolder() != null) {
                return teamProject.getReportingFolder().getFullItemPath();
            }
        }
        return null;
    }
}

