/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BaselineUpdaterAsyncOperation
extends AsyncOperation {
    private static final Log log = LogFactory.getLog(BaselineUpdaterAsyncOperation.class);
    private final List<BaselineRequest> failedRequests = new ArrayList<BaselineRequest>();
    private final BaselineFolderCollection baselineFolders;

    public BaselineUpdaterAsyncOperation(BaselineFolderCollection baselineFolders) {
        this.baselineFolders = baselineFolders;
    }

    public BaselineFolderCollection getBaselineFolderCollection() {
        return this.baselineFolders;
    }

    public synchronized List<BaselineRequest> getFailedRequests() {
        return this.failedRequests;
    }

    public synchronized void addFailedRequest(BaselineRequest baselineRequst) {
        this.failedRequests.add(baselineRequst);
    }

    public static void waitForCompletions(AccountingCompletionService<WorkerStatus> completionService) {
        Check.notNull(completionService, "completionService");
        completionService.waitForCompletions(new AccountingCompletionService.ResultProcessor<WorkerStatus>(){

            @Override
            public void processResult(WorkerStatus result) {
                WorkerStatus status = result;
                if (status.getFinalState() == WorkerStatus.FinalState.ERROR) {
                    log.debug((Object)"Baseline updater finished with ERROR");
                } else if (status.getFinalState() == WorkerStatus.FinalState.CANCELED) {
                    log.debug((Object)"Baseline updater thread finished with CANCELED");
                }
            }
        }, new AccountingCompletionService.ExecutionExceptionHandler(){

            @Override
            public void handleException(ExecutionException e) {
                log.warn((Object)"Baseline updater exception", (Throwable)e);
            }
        });
    }
}

