/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLMapper;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLStringMappings;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HSQLMapper
implements SQLMapper {
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");

    @Override
    public String getSQLColumnTypeFromMetadataColumnType(String type, String tableName, String columnName) {
        if ("System.Guid".equals(type)) {
            return "varchar(80)";
        }
        if ("System.Int32".equals(type)) {
            return "int";
        }
        if ("System.String".equals(type)) {
            int len = SQLStringMappings.getStringColumnLength(tableName, columnName);
            if (len == -1) {
                return "longvarchar";
            }
            return "varchar(" + len + ")";
        }
        if ("System.Boolean".equals(type)) {
            return "bit";
        }
        if ("System.DateTime".equals(type)) {
            return "datetime";
        }
        if ("System.UInt64".equals(type)) {
            return "bigint";
        }
        return "text";
    }

    @Override
    public Object getSQLObject(String type, String value) {
        if ("System.Int32".equals(type)) {
            return Integer.valueOf(value);
        }
        if ("System.Boolean".equals(type)) {
            return "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("System.UInt64".equals(type)) {
            return Long.valueOf(value);
        }
        if ("System.DateTime".equals(type)) {
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            Date d = null;
            String pVal = null;
            try {
                pVal = value.substring(0, 10) + " " + value.substring(11) + " -0000";
                d = this.DATE_FORMAT.parse(pVal);
            }
            catch (Exception ex) {
                throw new RuntimeException(MessageFormat.format("unable to parse [{0}]", pVal), ex);
            }
            Timestamp ts = new Timestamp(d.getTime());
            return ts;
        }
        return value;
    }
}

