/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RevisionsRowSetHandler
implements RowSetParseHandler {
    private final WorkItemImpl workItem;
    private List<String[]> rows;
    private List<String> columns;
    private int curColIx;
    private int revColIx;

    public RevisionsRowSetHandler(WorkItemImpl workItem) {
        this.workItem = workItem;
    }

    private void createRevisions() {
        RevisionImpl revision = RevisionImpl.createFromFieldCollection(this.workItem.getFieldsInternal(), this.workItem.getContext(), this.rows.size(), this.workItem.getRevisionsInternal());
        Collections.sort(this.rows, new RowComparator());
        for (String[] rowValues : this.rows) {
            for (int i = 0; i < rowValues.length; ++i) {
                String value;
                if (rowValues[i] == null || (value = rowValues[i].trim()).length() <= 0) continue;
                String fieldName = this.columns.get(i);
                revision.getFieldInternal(fieldName).setOldValueFromString(value);
            }
            this.workItem.getRevisionsInternal().addRevisionToStart(revision);
            revision = revision.createCopyForPreviousRevision();
        }
        revision.convertToInitialRevision();
        this.workItem.getRevisionsInternal().addRevisionToStart(revision);
    }

    @Override
    public void handleBeginParsing() {
        this.rows = new ArrayList<String[]>();
        this.columns = new ArrayList<String>();
        this.curColIx = 0;
        this.revColIx = -1;
    }

    @Override
    public void handleColumn(String name, String type) {
        this.columns.add(name);
        if ("System.Rev".equals(name)) {
            this.revColIx = this.curColIx;
        }
        ++this.curColIx;
    }

    @Override
    public void handleEndParsing() {
        this.createRevisions();
    }

    @Override
    public void handleFinishedColumns() {
        if (this.revColIx == -1) {
            throw new IllegalStateException(MessageFormat.format("columns did not contain rev: {0}", this.columns));
        }
    }

    @Override
    public void handleRow(String[] rowValues) {
        this.rows.add(rowValues);
    }

    @Override
    public void handleTableName(String tableName) {
    }

    private class RowComparator
    implements Comparator<String[]> {
        private RowComparator() {
        }

        @Override
        public int compare(String[] row1, String[] row2) {
            int rev1 = Integer.parseInt(row1[RevisionsRowSetHandler.this.revColIx]);
            int rev2 = Integer.parseInt(row2[RevisionsRowSetHandler.this.revColIx]);
            return rev2 - rev1;
        }
    }
}

