/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.jni.KeychainInternetPassword;
import com.microsoft.tfs.jni.KeychainProtocol;
import com.microsoft.tfs.jni.KeychainUtils;
import com.microsoft.tfs.util.Check;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeychainCredentialsManager
implements CredentialsManager {
    private static final Log log = LogFactory.getLog(KeychainCredentialsManager.class);

    @Override
    public String getUIMechanismName() {
        return Messages.getString("KeychainCredentialsManager.Keychain");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public CachedCredentials[] getCredentials() {
        return null;
    }

    @Override
    public CachedCredentials getCredentials(URI serverURI) {
        Check.notNull(serverURI, "serverURI");
        serverURI = URIUtils.removePathAndQueryParts(serverURI);
        KeychainInternetPassword keychainPassword = KeychainUtils.getInstance().findInternetPassword(KeychainCredentialsManager.newKeychainInternetPasswordFromURI(serverURI), true);
        if (keychainPassword == null) {
            return null;
        }
        String username = keychainPassword.getAccountName();
        String password = null;
        if (keychainPassword.getPassword() != null && keychainPassword.getPassword().length > 0) {
            try {
                password = new String(keychainPassword.getPassword(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Could not convert byte array to plaintext", (Throwable)e);
                return null;
            }
        }
        return new CachedCredentials(serverURI, username, password);
    }

    @Override
    public boolean setCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        URI serverURI = URIUtils.removePathAndQueryParts(cachedCredentials.getURI());
        cachedCredentials = new CachedCredentials(serverURI, cachedCredentials.getUsername(), cachedCredentials.getPassword());
        KeychainInternetPassword keychainPassword = KeychainCredentialsManager.newKeychainInternetPasswordFromURI(serverURI);
        keychainPassword.setAccountName(cachedCredentials.getUsername());
        if (cachedCredentials.getPassword() != null) {
            try {
                keychainPassword.setPassword(cachedCredentials.getPassword().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Could not convert plaintext to byte array", (Throwable)e);
                return false;
            }
        }
        return KeychainUtils.getInstance().addInternetPassword(keychainPassword, true);
    }

    @Override
    public boolean removeCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        return this.removeCredentials(cachedCredentials.getURI());
    }

    @Override
    public boolean removeCredentials(URI uri) {
        Check.notNull(uri, "uri");
        URI serverURI = URIUtils.removePathAndQueryParts(uri);
        KeychainInternetPassword keychainPassword = KeychainCredentialsManager.newKeychainInternetPasswordFromURI(serverURI);
        return KeychainUtils.getInstance().removeInternetPassword(keychainPassword, true);
    }

    private static KeychainInternetPassword newKeychainInternetPasswordFromURI(URI uri) {
        Check.notNull(uri, "uri");
        KeychainInternetPassword keychainPassword = new KeychainInternetPassword();
        if ("http".equalsIgnoreCase(uri.getScheme())) {
            keychainPassword.setProtocol(KeychainProtocol.HTTP);
        } else if ("https".equalsIgnoreCase(uri.getScheme())) {
            keychainPassword.setProtocol(KeychainProtocol.HTTPS);
        } else {
            keychainPassword.setProtocol(KeychainProtocol.ANY);
        }
        if (uri.getHost() != null && uri.getHost().length() > 0) {
            keychainPassword.setServerName(uri.getHost());
        }
        if (uri.getPort() > 0) {
            keychainPassword.setPort(uri.getPort());
        }
        if (uri.getPath() != null) {
            keychainPassword.setPath(uri.getPath());
        }
        return keychainPassword;
    }
}

