/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pendingcheckin;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldDefinition;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldValue;
import com.microsoft.tfs.core.pendingcheckin.AffectedTeamProjects;
import com.microsoft.tfs.core.pendingcheckin.CheckinNoteFailure;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinNotes;
import com.microsoft.tfs.core.pendingcheckin.events.NotesChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.NotesChangedListener;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;

public class StandardPendingCheckinNotes
implements PendingCheckinNotes {
    private final SingleListenerFacade notesChangedListeners = new SingleListenerFacade(NotesChangedListener.class);
    private final AffectedTeamProjects affectedTeamProjects;
    private CheckinNote checkinNotes;
    private CheckinNoteFieldDefinition[] fieldDefinitions;
    private final VersionControlClient client;

    public StandardPendingCheckinNotes(CheckinNote checkinNotes, VersionControlClient client, AffectedTeamProjects affectedTeamProjects) {
        Check.notNull(checkinNotes, "checkinNotes");
        Check.notNull(client, "client");
        Check.notNull(affectedTeamProjects, "affectedTeamProjects");
        this.checkinNotes = checkinNotes;
        this.client = client;
        this.affectedTeamProjects = affectedTeamProjects;
    }

    @Override
    public synchronized CheckinNoteFailure[] evaluate() {
        HashMap<String, CheckinNoteFailure> noteNameToNoteFailureMap = new HashMap<String, CheckinNoteFailure>();
        SortedSet<CheckinNoteFieldDefinition> definitions = this.client.queryCheckinNoteFieldDefinitionsForServerPaths(this.affectedTeamProjects.getTeamProjectPaths());
        if (definitions == null) {
            this.fieldDefinitions = new CheckinNoteFieldDefinition[0];
        } else {
            CheckinNoteFieldDefinition[] array = new CheckinNoteFieldDefinition[definitions.size()];
            int index = 0;
            Iterator i = definitions.iterator();
            while (i.hasNext()) {
                array[index++] = (CheckinNoteFieldDefinition)i.next();
            }
            this.fieldDefinitions = array;
        }
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            CheckinNoteFieldDefinition definition = this.fieldDefinitions[i];
            if (!definition.isRequired()) continue;
            boolean found = false;
            if (this.checkinNotes != null && this.checkinNotes.getValues() != null) {
                for (int j = 0; j < this.checkinNotes.getValues().length; ++j) {
                    CheckinNoteFieldValue thisNoteValue = this.checkinNotes.getValues()[j];
                    if (thisNoteValue.getValue() == null || thisNoteValue.getValue().length() <= 0 || !thisNoteValue.getName().trim().equalsIgnoreCase(definition.getName().trim())) continue;
                    found = true;
                    break;
                }
            }
            if (found || noteNameToNoteFailureMap.containsKey(definition.getName())) continue;
            noteNameToNoteFailureMap.put(definition.getName(), new CheckinNoteFailure(definition, Messages.getString("StandardPendingCheckinNotes.AValueMustBeSpecifiedForTheCheckInNoteFormat")));
        }
        return noteNameToNoteFailureMap.values().toArray(new CheckinNoteFailure[noteNameToNoteFailureMap.values().size()]);
    }

    @Override
    public synchronized CheckinNote getCheckinNotes() {
        return this.checkinNotes;
    }

    @Override
    public synchronized void setCheckinNotes(CheckinNote checkinNotes) {
        Check.notNull(checkinNotes, "checkinNotes");
        this.checkinNotes = checkinNotes;
        ((NotesChangedListener)this.notesChangedListeners.getListener()).onNotesChanged(new NotesChangedEvent(EventSource.newFromHere(), checkinNotes));
    }

    @Override
    public synchronized CheckinNoteFieldDefinition[] getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    @Override
    public void addNotesChangedListener(NotesChangedListener listener) {
        this.notesChangedListeners.addListener(listener);
    }

    @Override
    public void removeNotesChangedListener(NotesChangedListener listener) {
        this.notesChangedListeners.removeListener(listener);
    }
}

