/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.transport;

import com.microsoft.tfs.core.httpclient.ActiveHttpMethods;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPConnectionCanceller
extends Thread {
    private static final Log log = LogFactory.getLog(HTTPConnectionCanceller.class);
    private static final long ACTIVE_METHODS_CHECK_MILLISECONDS = 1000L;
    private static final long ABORT_WAIT_MILLISECONDS = 5000L;
    private final Map<TaskMonitor, Object> cancelledMonitors = new WeakHashMap<TaskMonitor, Object>();
    private final List<MethodAbortInfo> scheduledAborts = new ArrayList<MethodAbortInfo>();

    public HTTPConnectionCanceller() {
        this.setDaemon(true);
        super.setName("HTTP Method Canceller");
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.abort();
                for (Map.Entry<Object, HttpMethod> entry : ActiveHttpMethods.getMonitorMethods().entrySet()) {
                    HttpMethod method;
                    TaskMonitor tm;
                    Object key = entry.getKey();
                    if (!(key instanceof TaskMonitor) || !(tm = (TaskMonitor)key).isCanceled() || this.cancelledMonitors.containsKey(tm) || (method = entry.getValue()) == null) continue;
                    this.cancelledMonitors.put(tm, null);
                    log.trace((Object)MessageFormat.format("Schedling abort for {0} in {1} ms", method, 5000L));
                    this.scheduledAborts.add(new MethodAbortInfo(System.currentTimeMillis() + 5000L, method));
                }
                log.trace((Object)MessageFormat.format("sleeping (aborted weak map size={0})", this.cancelledMonitors.size()));
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)"interrupted; exiting thread");
        }
        catch (Throwable t) {
            log.error((Object)"unexpected error", t);
        }
    }

    private void abort() {
        Iterator<MethodAbortInfo> i = this.scheduledAborts.iterator();
        while (i.hasNext()) {
            MethodAbortInfo info = i.next();
            if (System.currentTimeMillis() <= info.abortAfter) continue;
            log.trace((Object)MessageFormat.format("aborting method {0}", info.method));
            try {
                info.method.abort();
            }
            catch (Throwable t) {
                log.warn((Object)MessageFormat.format("error while aborting method {0}", info.method), t);
            }
            i.remove();
        }
    }

    private static class MethodAbortInfo {
        public final long abortAfter;
        public final HttpMethod method;

        public MethodAbortInfo(long abortAfter, HttpMethod method) {
            this.abortAfter = abortAfter;
            this.method = method;
        }
    }
}

