/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.encoder.entry;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedEncoder;
import java.io.File;
import java.io.IOException;

public class AppleForkedCommentEncoder
extends ByteArrayChunkedEncoder
implements AppleForkedEntryEncoder {
    private final byte[] comment;

    public AppleForkedCommentEncoder(File file) {
        byte[] comment = FileSystemUtils.getInstance().getMacExtendedAttribute(AppleForkedCommentEncoder.getFilename(file), "com.apple.metadata:kMDItemFinderComment");
        this.comment = comment != null ? comment : new byte[]{};
    }

    private static String getFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    @Override
    public long getType() {
        return 4L;
    }

    @Override
    public long getLength() {
        return this.comment.length;
    }

    @Override
    protected byte[] start() throws IOException {
        return this.comment;
    }

    @Override
    public void close() throws IOException {
    }
}

