/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.teamscale.commons.ServiceApiInfo;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.read.BackupImportOptions;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupImportStatusIndex;
import com.teamscale.index.backup.read.BackupImportTrigger;
import com.teamscale.index.backup.tempfile.TemporaryFileIndexBackupTarget;
import com.teamscale.index.backup.write.EBackupExportExcludeOptions;
import com.teamscale.index.backup.write.EExternalDataExportGranularity;
import com.teamscale.index.backup.write.EExternalDataExportTarget;
import com.teamscale.service.admin.backup.BackupImportJobService;
import com.teamscale.service.admin.backup.BackupImportParameters;
import com.teamscale.service.admin.backup.BackupImportSummaryService;
import com.teamscale.service.admin.backup.ExternalDataExportOption;
import com.teamscale.service.admin.backup.RemoteImportParameters;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;

public class BackupImportService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @Context
    ResourceContext context;
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.BACKUP})
    @Operation(summary="Import backup.", description="Triggers the import of a backup and returns the job ID.", tags={"Backup"})
    @Consumes(value={"multipart/form-data"})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_1_0)
    public String importBackup(@BeanParam BackupImportParameters backupImportParameters) throws StorageException, ServiceCallException {
        BackupImportOptions backupImportOptions = BackupImportService.createBackupImportOptions(backupImportParameters.isEnableShadowMode(), backupImportParameters.isSkipNewProjects(), backupImportParameters.isSkipProjectValidation(), backupImportParameters.isSkipGlobalDataImport());
        String backup = BackupImportService.importBackup(this.getIndexLayer(), backupImportOptions, backupImportParameters.getBackupPath(), this.getRemoteInstanceCredentials(backupImportParameters.getRemoteUrl(), backupImportParameters.getRemoteUser(), backupImportParameters.getAccessToken()), backupImportParameters.getBackup(), formDataBodyPart -> (InputStream)formDataBodyPart.getValueAs(InputStream.class));
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, "Backup import event");
        return backup;
    }

    @POST
    @Path(value="remote")
    @Operation(summary="Import backup from remote.", description="Triggers the import and export of a backup and returns the job ID.", tags={"Backup"})
    @RequiresGlobalPermission(value={EGlobalPermission.BACKUP})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_8_0)
    public String importBackupFromRemote(RemoteImportParameters parameters) throws StorageException, ServiceCallException {
        BackupImportOptions backupImportOptions = BackupImportService.createBackupImportOptions(parameters.enableShadowMode(), parameters.skipNewProjects(), parameters.skipProjectValidation(), parameters.skipGlobalDataImport());
        InstanceCredentials credentials = this.getRemoteInstanceCredentials(parameters.remoteUrl(), parameters.remoteUser(), parameters.accessToken());
        IBackupExportService backupExportService = (IBackupExportService)Retrofit.builder((String)credentials.getTeamscaleUrl()).withBasicNTLMAuthentication(credentials.getUsername(), credentials.getApiToken()).withInteractionLogger(LOGGER).create(IBackupExportService.class);
        BackupImportService.verifyRemoteTeamscaleVersion(backupExportService, ETeamscaleVersion.VERSION_2024_8_0.toVersionObject());
        Set<PublicProjectId> includedProjects = Collections.emptySet();
        if (parameters.skipNewProjects()) {
            ProjectIndex index = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
            includedProjects = new HashSet(index.getAllPrimaryPublicProjectIds());
        }
        String exportId = BackupImportService.executeServiceCall(backupExportService.exportWithOptions(!parameters.skipGlobalDataImport(), !parameters.skipNewProjects(), includedProjects, BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::granularity), BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::target), BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::exportOptionDate), BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::branchPattern), BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::partitionPattern), BackupImportService.mapParametersToUploadsOptions(parameters, ExternalDataExportOption::projectPattern), parameters.exportExcludeOptions()));
        URI importUri = URI.create(StringUtils.ensureEndsWith((String)("ts+" + credentials.getTeamscaleUrl()), (String)"/")).resolve("api/v2024.8/backups/export/").resolve(exportId);
        backupImportOptions.addImportUri(importUri);
        backupImportOptions.setInstanceCredentials(credentials);
        String backupId = UUID.randomUUID().toString();
        BackupImportStatus backupSummary = new BackupImportStatus(backupImportOptions);
        BackupImportService.writeBackupSummary(backupId, backupSummary, this.getIndexLayer());
        BackupImportService.scheduleBackupImportTrigger(backupId, this.getIndexLayer());
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, "Backup import event");
        return backupId;
    }

    private static <T> List<T> mapParametersToUploadsOptions(RemoteImportParameters parameters, Function<ExternalDataExportOption, T> mapper) {
        return parameters.externalDataExportOptions().stream().map(mapper).toList();
    }

    @VisibleForTesting
    public static <T> String importBackup(IndexLayer indexLayer, BackupImportOptions backupImportOptions, String backupPath, InstanceCredentials remoteCredentials, List<T> backups, Function<T, InputStream> streamProvider) throws StorageException, ServiceCallException {
        BackupImportService.appendImportUrls(backupPath, backups, streamProvider, backupImportOptions, indexLayer);
        BackupImportService.appendRemoteInstance(remoteCredentials, backupImportOptions);
        String backupId = UUID.randomUUID().toString();
        BackupImportStatus backupSummary = new BackupImportStatus(backupImportOptions);
        BackupImportService.writeBackupSummary(backupId, backupSummary, indexLayer);
        BackupImportService.scheduleBackupImportTrigger(backupId, indexLayer);
        AuditLogs.backupImported((String)backupId);
        return backupId;
    }

    private static void scheduleBackupImportTrigger(String backupId, IndexLayer indexLayer) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, BackupImportTrigger.class, null, (Object)backupId, "Scheduled due to backup import '" + backupId + "'."));
    }

    private static <T> void appendImportUrls(String backupPath, List<T> backups, Function<T, InputStream> streamProvider, BackupImportOptions backupImportOptions, IndexLayer indexLayer) throws StorageException {
        if (!StringUtils.isEmpty((String)backupPath)) {
            if (new File(backupPath).exists()) {
                backupImportOptions.addImportUri(new File(backupPath).toURI());
            } else {
                backupImportOptions.addImportUri(URI.create(backupPath));
            }
            return;
        }
        if (backups == null) {
            return;
        }
        TemporaryFileIndex fileIndex = (TemporaryFileIndex)indexLayer.openGlobalIndex(TemporaryFileIndex.class);
        try {
            backupImportOptions.setDeleteAfterImport(true);
            for (T backup : backups) {
                String outputFilename = fileIndex.getTemporaryFileName();
                InputStream inputStream = streamProvider.apply(backup);
                try {
                    OutputStream outputStream = fileIndex.writeFile(outputFilename);
                    try {
                        FileSystemUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        backupImportOptions.addImportUri(TemporaryFileIndexBackupTarget.buildURI((String)outputFilename));
                    }
                    finally {
                        if (outputStream == null) continue;
                        outputStream.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Fatal error during backup import: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void appendRemoteInstance(@Nullable InstanceCredentials remoteCredentials, BackupImportOptions backupImportOptions) throws ServiceCallException {
        if (remoteCredentials == null || StringUtils.isEmpty((String)remoteCredentials.getTeamscaleUrl())) {
            return;
        }
        IBackupExportService backupExportService = (IBackupExportService)Retrofit.builder((String)remoteCredentials.getTeamscaleUrl()).withBasicNTLMAuthentication(remoteCredentials.getUsername(), remoteCredentials.getApiToken()).withInteractionLogger(LOGGER).create(IBackupExportService.class);
        BackupImportService.verifyRemoteTeamscaleVersion(backupExportService, ETeamscaleVersion.VERSION_8_5_0.toVersionObject());
        String backupId = BackupImportService.executeServiceCall(backupExportService.export(true, true, true, true));
        URI importUri = URI.create(StringUtils.ensureEndsWith((String)("ts+" + remoteCredentials.getTeamscaleUrl()), (String)"/")).resolve("api/v6.1/backups/export/").resolve(backupId);
        backupImportOptions.addImportUri(importUri);
        backupImportOptions.setInstanceCredentials(remoteCredentials);
    }

    private static void verifyRemoteTeamscaleVersion(IBackupExportService backupExportService, Version minimumRequiredVersion) throws ServiceCallException {
        Version remoteServerVersion = BackupImportService.executeServiceCall(backupExportService.getTeamscaleVersion()).getMaxApiVersion();
        if (!remoteServerVersion.isGreaterOrEqual(minimumRequiredVersion)) {
            throw new BadRequestException("Remote Teamscale instance must be at least version %s but was %s".formatted(minimumRequiredVersion, remoteServerVersion));
        }
    }

    private static void writeBackupSummary(String id, BackupImportStatus backupSummary, IndexLayer indexLayer) throws StorageException {
        ((BackupImportStatusIndex)indexLayer.openGlobalIndex(BackupImportStatusIndex.class)).setStatus(id, backupSummary);
    }

    private static BackupImportOptions createBackupImportOptions(boolean enableShadowMode, boolean skipNewProjects, boolean skipProjectValidation, boolean skipGlobalDataImport) {
        return new BackupImportOptions().setSkipNewProjects(skipNewProjects).setSkipValidation(skipProjectValidation).setImportGlobalData(!skipGlobalDataImport).setEnableShadowMode(enableShadowMode);
    }

    @Path(value="{backupId}")
    public BackupImportJobService getJobService(@Parameter(description="The backup ID.", required=true) @PathParam(value="backupId") String backupId) {
        return (BackupImportJobService)this.context.initResource((Object)new BackupImportJobService(backupId));
    }

    @Path(value="summary")
    public Class<BackupImportSummaryService> getSummariesService() {
        return BackupImportSummaryService.class;
    }

    @Override
    protected InstanceCredentials getRemoteInstanceCredentials(String remoteUrl, String remoteUserName, String remoteAccessToken) throws StorageException {
        if (StringUtils.isEmpty((String)remoteUrl)) {
            return null;
        }
        return super.getRemoteInstanceCredentials(remoteUrl, remoteUserName, remoteAccessToken);
    }

    private static <T> @NonNull T executeServiceCall(Call<T> call) throws ServiceCallException {
        return Retrofit.executeServiceCall(call).orElseThrow(() -> new WebApplicationException("Invalid response from the remote Teamscale instance.", Response.Status.BAD_GATEWAY));
    }

    private static interface IBackupExportService
    extends IRetrofitApi {
        @retrofit2.http.POST(value="api/v6.1/backups/export")
        @FormUrlEncoded
        public Call<String> export(@Field(value="backup-global") boolean var1, @Field(value="include-all-visible-projects") boolean var2, @Field(value="include-pending-external-upload-sessions") boolean var3, @Field(value="include-git-labeling-info") boolean var4);

        @retrofit2.http.POST(value="api/v2024.8/backups/export")
        @FormUrlEncoded
        public Call<String> exportWithOptions(@Field(value="backup-global") boolean var1, @Field(value="include-all-visible-projects") boolean var2, @Field(value="include-project") Set<PublicProjectId> var3, @Field(value="export-option-granularity") List<EExternalDataExportGranularity> var4, @Field(value="export-option-target") List<EExternalDataExportTarget> var5, @Field(value="export-option-date") List<String> var6, @Field(value="export-option-branch") List<String> var7, @Field(value="export-option-partition") List<String> var8, @Field(value="export-option-project") List<String> var9, @Field(value="export-exclude-options") Set<EBackupExportExcludeOptions> var10);

        @GET(value="api/v5.8/version")
        public Call<ServiceApiInfo> getTeamscaleVersion();
    }
}

