/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.profiler;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.profiler.DetailedProfilerLog;
import com.teamscale.core.log.profiler.GlobalProfilerLogIndex;
import com.teamscale.core.log.profiler.ShortProfilerLog;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.admin.profiler.EProfilerHealth;
import com.teamscale.index.admin.profiler.EProfilerLogSeverity;
import com.teamscale.index.admin.profiler.EProfilerStatus;
import com.teamscale.index.admin.profiler.ProcessInformation;
import com.teamscale.index.admin.profiler.ProfilerConfiguration;
import com.teamscale.index.admin.profiler.ProfilerConfigurationIndex;
import com.teamscale.index.admin.profiler.ProfilerInfo;
import com.teamscale.index.admin.profiler.ProfilerRegistration;
import com.teamscale.index.admin.profiler.RunningProfilerInfo;
import com.teamscale.index.admin.profiler.RunningProfilersIndex;
import com.teamscale.service.admin.profiler.ProfilerLogEntry;
import com.teamscale.service.admin.profiler.RunningProfilerInfoDTO;
import com.teamscale.service.admin.profiler.RunningProfilersResult;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.eclipse.jgit.util.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/profilers")
public class RunningProfilersService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get the list of all known profiler instances and their status", description="Retrieves the list of all profiler instances in the system", tags={"Profilers"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    public RunningProfilersResult getRunningProfilers(@BeanParam SortAndPaginationOptions sortAndPaginationOptions, @QueryParam(value="status") @Nullable EProfilerStateQuery withStatus) throws StorageException {
        RunningProfilersIndex runningProfilersIndex = this.openGlobalIndex(RunningProfilersIndex.class);
        List<RunningProfilerInfoDTO> result = this.filterProfilerInfos(runningProfilersIndex.getAllProfilerRuns(), withStatus).map(RunningProfilerInfoDTO::new).toList();
        return RunningProfilersResult.from(result, sortAndPaginationOptions);
    }

    private Stream<RunningProfilerInfo> filterProfilerInfos(List<RunningProfilerInfo> allRunningProfilers, @Nullable EProfilerStateQuery withStatus) {
        return allRunningProfilers.stream().filter(info -> this.getPermissions().hasBasicPermission(EBasicPermissionScope.PROFILER_CONFIGURATIONS, info.profilerInfo().profilerConfiguration().configurationId(), EBasicPermission.VIEW)).filter(info -> withStatus == null || withStatus.matchesState(info.getStatus()));
    }

    @POST
    @Operation(summary="Push more logs of a running profiler", description="Push more logs of a running profiler", tags={"Profilers"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @PublicApi(since=ETeamscaleVersion.VERSION_2024_8_0)
    @Path(value="{profilerId}/logs")
    public void postProfilerLog(@PathParam(value="profilerId") UUID profilerId, @RequestBody List<ProfilerLogEntry> entries) throws StorageException {
        @NonNull RunningProfilerInfo profilerInfo = this.getAndAssertRunningProfilerInfo(profilerId);
        EProfilerHealth profilerHealth = profilerInfo.health();
        this.checkPermissionsForProfilerAccess(profilerInfo.profilerInfo());
        String failureMessage = null;
        GlobalProfilerLogIndex targetIndex = this.openGlobalIndex(GlobalProfilerLogIndex.class);
        targetIndex.setProfiler(profilerInfo.id());
        for (ProfilerLogEntry entry : entries) {
            DetailedProfilerLog detailedProfilerLog;
            boolean hasDetails = !StringUtils.isEmptyOrNull((String)entry.getDetails());
            int debugCount = entry.getSeverity() == EProfilerLogSeverity.DEBUG ? 1 : 0;
            int errorCount = entry.getSeverity() == EProfilerLogSeverity.ERROR ? 1 : 0;
            int warningCount = entry.getSeverity() == EProfilerLogSeverity.WARNING ? 1 : 0;
            ShortProfilerLog shortLogEntry = new ShortProfilerLog(LogEntryIdentifier.freshWithTimestamp((long)entry.getTimestamp()), entry.getSeverity().toLogLevel(), new LogCount(debugCount, 0, warningCount, errorCount, 0), entry.getMessage());
            if (entry.getSeverity() == EProfilerLogSeverity.ERROR) {
                failureMessage = entry.getMessage();
            }
            if (hasDetails) {
                String message = entry.getDetails();
                long time = entry.getTimestamp();
                detailedProfilerLog = new DetailedProfilerLog(shortLogEntry.getId(), List.of(new LoggingEventTransport(message, entry.getSeverity().toLogLevel(), time, null, Collections.emptyMap())));
            } else {
                detailedProfilerLog = new DetailedProfilerLog(shortLogEntry.getId(), List.of());
            }
            targetIndex.insertLog((ShortLogEntryBase)shortLogEntry, (DetailedLogEntryBase)detailedProfilerLog);
            profilerHealth = profilerHealth.joinSeverity(entry.getSeverity());
        }
        this.storeProfilerInfo(profilerInfo.withHealth(profilerHealth).withFailure(failureMessage));
    }

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @Operation(summary="Get all logs produced by the profiler", description="Returns a list of all profiler short logs.", tags={"Profilers"})
    @Path(value="{profilerId}/logs")
    public ShortLogResponse<ShortProfilerLog> getProfilerLogs(@PathParam(value="profilerId") UUID profilerId, @BeanParam LogFilteringParameters logFilteringParameters) throws StorageException {
        RunningProfilerInfo profilerInfo = this.getAndAssertRunningProfilerInfo(profilerId);
        this.checkPermissionsForProfilerAccess(profilerInfo.profilerInfo());
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.getLogIndexesWrapper(profilerId));
    }

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @Operation(summary="Get the profiler log detail", description="Returns the detailed profiler log entry for the given timestamp.", tags={"Logging"})
    @Path(value="{profilerId}/logs/{id}")
    public DetailedProfilerLog getProfilerLogDetail(@PathParam(value="profilerId") UUID profilerId, @PathParam(value="id") LogEntryIdentifier id) throws StorageException {
        RunningProfilerInfo profilerInfo = this.getAndAssertRunningProfilerInfo(profilerId);
        this.checkPermissionsForProfilerAccess(profilerInfo.profilerInfo());
        return (DetailedProfilerLog)LogServiceUtils.getDetailedLogEntry(this.getLogIndexesWrapper(profilerId), (LogEntryIdentifier)id);
    }

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @Operation(summary="Download profiler logs", description="Returns a file download of all profiler logs.", tags={"Profilers"})
    @Path(value="{profilerId}/logs/download")
    public Response downloadProfilerLogs(@PathParam(value="profilerId") UUID profilerId, @BeanParam LogFilteringParameters logFilteringParameters, @Parameter(description="Limit the returned log to at most N characters. Default = 0, meaning that the full log is returned.") @QueryParam(value="maxChars") @DefaultValue(value="0") int maxChars) throws StorageException {
        RunningProfilerInfo profilerInfo = this.getAndAssertRunningProfilerInfo(profilerId);
        this.checkPermissionsForProfilerAccess(profilerInfo.profilerInfo());
        return LogServiceUtils.createLogDownload((String)"ProfilerLog.txt", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.getLogIndexesWrapper(profilerId));
    }

    @DELETE
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler infos that use a profiler configuration that is visible to the current user.")
    @Operation(summary="Delete profiler logs based on the given filter and reset the profiler health state", description="Delete the logs of the coverage profiler that match the given filter and reset the health state of the profiler", tags={"Profilers"})
    @Path(value="{profilerId}/logs")
    public void deleteProfilerLogs(@PathParam(value="profilerId") UUID profilerId, @BeanParam LogFilteringParameters logFilteringParameters) throws StorageException {
        RunningProfilerInfo profilerInfo = this.getAndAssertRunningProfilerInfo(profilerId);
        this.checkPermissionsForProfilerAccess(profilerInfo.profilerInfo());
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.getLogIndexesWrapper(profilerId));
        this.storeProfilerInfo(profilerInfo.withHealth(EProfilerHealth.OK));
    }

    private @NonNull LogIndexesWrapper<ShortProfilerLog, DetailedProfilerLog> getLogIndexesWrapper(UUID profilerId) throws StorageException {
        return RunningProfilersService.createLogIndexesWrapper(this.getIndexLayer(), profilerId);
    }

    public static @NonNull LogIndexesWrapper<ShortProfilerLog, DetailedProfilerLog> createLogIndexesWrapper(IndexLayer indexLayer, UUID profilerId) throws StorageException {
        GlobalProfilerLogIndex profilerLogIndex = LogServiceUtils.getProfilerLogIndex((IndexLayer)indexLayer, (UUID)profilerId);
        return new LogIndexesWrapper(PairList.from((Object)new PublicProjectId("dummy-profiler-id"), (Object)profilerLogIndex));
    }

    public static List<RunningProfilerInfo> getAllProfilerRuns(IndexLayer indexLayer) throws StorageException {
        RunningProfilersIndex profilersIndex = (RunningProfilersIndex)indexLayer.openGlobalIndex(RunningProfilersIndex.class);
        return profilersIndex.getAllProfilerRuns();
    }

    @GET
    @Path(value="{profilerId}")
    @Operation(summary="Get running profiler", description="Retrieves the running profiler", tags={"Profilers"})
    @RequiresNoPermission(description="The user needs to have VIEW permissions on the configuration this profiler is using.")
    public RunningProfilerInfo getRunningProfiler(@PathParam(value="profilerId") UUID profilerId) throws StorageException {
        RunningProfilerInfo runningProfiler = this.getAndAssertRunningProfilerInfo(profilerId);
        this.checkPermissionsForProfilerAccess(runningProfiler.profilerInfo());
        return runningProfiler;
    }

    private @NonNull RunningProfilerInfo getAndAssertRunningProfilerInfo(UUID profilerId) throws StorageException {
        RunningProfilersIndex runningProfilersIndex = this.openGlobalIndex(RunningProfilersIndex.class);
        RunningProfilerInfo runningProfiler = runningProfilersIndex.getRunningProfilerInfo(profilerId);
        if (runningProfiler == null) {
            throw new BadRequestException("Profiler with ID " + String.valueOf(profilerId) + " does not exist!");
        }
        return runningProfiler;
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0)
    @RequiresBasicPermission(scope=EBasicPermissionScope.PROFILER_CONFIGURATIONS, permissions={EBasicPermission.VIEW}, entityQueryParameter="configuration-id")
    @Operation(summary="Registers a profiler instance", description="Registers a profiler to Teamscale and returns the profiler configuration it should be started with.", tags={"Profilers"})
    public ProfilerRegistration registerProfiler(@Parameter(description="The ID of the profiler configuration to retrieve.", required=true) @QueryParam(value="configuration-id") String configurationId, @RequestBody(required=true) ProcessInformation processInformation) throws StorageException {
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        ProfilerConfiguration profilerConfiguration = profilerConfigurationIndex.getProfilerConfiguration(configurationId);
        if (profilerConfiguration == null) {
            throw new NotFoundException("No profiler configuration with the ID '" + configurationId + "' does exist!");
        }
        RunningProfilerInfo runningProfilerInfo = this.storeProfilerInfo(RunningProfilerInfo.makeNewlyRegistered((ProcessInformation)processInformation, (ProfilerConfiguration)profilerConfiguration));
        return new ProfilerRegistration(runningProfilerInfo.id(), profilerConfiguration);
    }

    @PUT
    @Path(value="{profilerId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0)
    @RequiresNoPermission(description="The user needs to have VIEW permissions on the configuration this profiler is using.")
    @Operation(summary="Profiler heartbeat", description="Updates the profiler infos and sets the profiler to still alive.", tags={"Profilers"})
    public void receiveHeartbeat(@Parameter(description="The ID of the profiler to update.", required=true) @PathParam(value="profilerId") UUID profilerId, @RequestBody(required=true) ProfilerInfo profilerInfo) throws StorageException {
        this.checkPermissionsForProfilerAccess(profilerInfo);
        this.storeProfilerInfo(this.getOrCreateCurrentlyRunningProfilerInfo(profilerId, profilerInfo));
    }

    private RunningProfilerInfo storeProfilerInfo(RunningProfilerInfo runningProfilerInfo) throws StorageException {
        RunningProfilersIndex runningProfilersIndex = this.openGlobalIndex(RunningProfilersIndex.class);
        runningProfilersIndex.updateProfilerInfo(runningProfilerInfo);
        return runningProfilerInfo;
    }

    private @NonNull RunningProfilerInfo getOrCreateCurrentlyRunningProfilerInfo(UUID profilerId, ProfilerInfo profilerInfo) throws StorageException {
        RunningProfilersIndex runningProfilersIndex = this.openGlobalIndex(RunningProfilersIndex.class);
        RunningProfilerInfo stored = runningProfilersIndex.getRunningProfilerInfo(profilerId);
        if (stored == null) {
            return RunningProfilerInfo.makeNewlyRegistered((ProcessInformation)profilerInfo.processInformation(), (ProfilerConfiguration)profilerInfo.profilerConfiguration()).withId(profilerId);
        }
        CCSMAssert.isTrue((boolean)stored.profilerInfo().profilerConfiguration().configurationId().equals(profilerInfo.profilerConfiguration().configurationId()), () -> "The profilers configuration ID unexpectedly changed from " + stored.profilerInfo().profilerConfiguration().configurationId() + " to " + profilerInfo.profilerConfiguration().configurationId());
        return stored.withHeartbeatNow();
    }

    @DELETE
    @Path(value="{profilerId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0)
    @RequiresNoPermission(description="The user needs to have VIEW permissions on the configuration this profiler is using.")
    @Operation(summary="Unregister profiler", description="Removes the profiler identified by given ID.", tags={"Profilers"})
    public void unregisterProfiler(@Parameter(description="The ID of the profiler to unregister.") @PathParam(value="profilerId") UUID profilerId) throws StorageException {
        RunningProfilersIndex runningProfilersIndex = this.openGlobalIndex(RunningProfilersIndex.class);
        RunningProfilerInfo oldRunningProfilerInfo = runningProfilersIndex.getRunningProfilerInfo(profilerId);
        if (oldRunningProfilerInfo == null) {
            LOGGER.info("Received profiler unregister request for unknown profiler ID " + String.valueOf(profilerId));
            return;
        }
        this.checkPermissionsForProfilerAccess(oldRunningProfilerInfo.profilerInfo());
        runningProfilersIndex.updateProfilerInfo(oldRunningProfilerInfo.withShutdownNow());
    }

    private void checkPermissionsForProfilerAccess(ProfilerInfo profilerInfo) {
        this.getPermissions().checkBasicPermission(EBasicPermissionScope.PROFILER_CONFIGURATIONS, profilerInfo.profilerConfiguration().configurationId(), EBasicPermission.VIEW);
    }

    @ExportToTypeScript
    public static enum EProfilerStateQuery {
        RUNNING,
        CLOSED;


        private boolean matchesState(EProfilerStatus status) {
            if (this == RUNNING) {
                return status == EProfilerStatus.ONLINE;
            }
            return status != EProfilerStatus.ONLINE;
        }
    }
}

