/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.audit.analysis.redundantliterals.RedundantLiteralIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.audit.RedundantLiteralQueryOptions;
import com.teamscale.service.audit.RedundantLiteralTreeMapBuilder;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/redundant-literals")
public class RedundantLiteralService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get redundant literals", description="Retrieves all redundant literals in the project.", tags={"Audit"}, responses={@ApiResponse(responseCode="400", description="Could not retrieve redundant literals. The analysis is possibly disabled in the analysis profile."), @ApiResponse(responseCode="400", description="Could not compile submitted regex.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<RedundantLiteralInfo> getRedundantLiteralsQuery(@BeanParam RedundantLiteralQueryOptions parameters, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        return this.getRedundantLiterals(parameters, commit);
    }

    @GET
    @Path(value="treemap")
    @Operation(summary="Get redundant literal treemap", description="Retrieves a treemap of all redundant literals.", tags={"Audit"}, responses={@ApiResponse(responseCode="400", description="Could not retrieve redundant literals. The analysis is possibly disabled in the analysis profile."), @ApiResponse(responseCode="400", description="Invalid regular expression used in parameters."), @ApiResponse(responseCode="400", description="Color metric required but not specified."), @ApiResponse(responseCode="400", description="Could not compile submitted regex.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public FilteredTreeMapWrapper getRedundantLiteralTreemap(@BeanParam RedundantLiteralQueryOptions parameters, @BeanParam TreemapQueryOptions treemapRequestOptions, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, TreeMapBuilderException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)parameters.getPath().getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        List<RedundantLiteralInfo> redundantLiteralInfos = this.loadTreemapParameters(parameters, commit, treemapRequestOptions, metricRetrievalStrategy.getMetricDirectorySchema());
        RedundantLiteralTreeMapBuilder redundantLiteralTreeMapBuilder = new RedundantLiteralTreeMapBuilder(metricRetrievalStrategy, this.determineHistoryOption(commit), treemapRequestOptions.areaMetricIndex, redundantLiteralInfos, true);
        return redundantLiteralTreeMapBuilder.getWrapper(parameters.getPath());
    }

    private PairList<String, CounterSet<String>> filterLiteralsByPath(PairList<String, CounterSet<String>> originalLiterals, String uniformPath, boolean localScopeMetric, HistoryAccessOption historyAccessOption) throws StorageException {
        if (uniformPath.isEmpty()) {
            return originalLiterals;
        }
        Function<Predicate<String>, PairList<String, CounterSet<String>>> filterLiteralsWithPredicate = RedundantLiteralService.getFilteredLiteralsWithPredicateFunction(originalLiterals, localScopeMetric);
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath((String)uniformPath)) {
            HashSet sourcePaths = new HashSet(ArchitectureMetricsUtils.getArchitectureFreeSourcePaths((String)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption));
            return filterLiteralsWithPredicate.apply(sourcePaths::contains);
        }
        return filterLiteralsWithPredicate.apply(fileName -> fileName.startsWith(uniformPath));
    }

    private static Function<Predicate<String>, PairList<String, CounterSet<String>>> getFilteredLiteralsWithPredicateFunction(PairList<String, CounterSet<String>> originalLiterals, boolean localScopeMetric) {
        return predicate -> {
            PairList result = new PairList();
            originalLiterals.forEach(pair -> {
                if (RedundantLiteralService.isMatchingPredicate(localScopeMetric, predicate, (Pair<String, CounterSet<String>>)pair)) {
                    result.add(pair);
                }
            });
            return result;
        };
    }

    private static boolean isMatchingPredicate(boolean localScopeMetric, Predicate<String> predicate, Pair<String, CounterSet<String>> pair) {
        if (localScopeMetric && ((CounterSet)pair.getSecond()).getKeys().stream().allMatch(predicate)) {
            return true;
        }
        return ((CounterSet)pair.getSecond()).getKeys().stream().anyMatch(predicate);
    }

    private List<RedundantLiteralInfo> getRedundantLiterals(RedundantLiteralQueryOptions parameters, UnresolvedCommitDescriptor commit) throws BadRequestException, StorageException {
        if (!this.projectIndexExists("redundantliterals")) {
            LOGGER.error("Error retrieving redundant literals. Did you enable the analysis in the analysis profile ('Other options')?");
            throw new BadRequestException("Error retrieving redundant literals. Did you enable the analysis in the analysis profile ('Other options')?");
        }
        Pattern includeLiteralPattern = parameters.getIncludeRegex();
        Pattern excludeLiteralPattern = parameters.getExcludeRegex();
        String cleanPath = UniformPathUtils.cleanPath((String)parameters.getPath().toString());
        PairList<String, CounterSet<String>> literalAndInfos = this.getLiteralInfos(parameters.isLocalScopeMetric(), cleanPath, this.determineHistoryOption(commit));
        ArrayList<RedundantLiteralInfo> redundantLiterals = new ArrayList<RedundantLiteralInfo>();
        for (int i = 0; i < literalAndInfos.size(); ++i) {
            CounterSet occurrencesByFile;
            String literal = (String)literalAndInfos.getFirst(i);
            assert (includeLiteralPattern != null);
            if (!includeLiteralPattern.matcher(literal).find() || excludeLiteralPattern != null && excludeLiteralPattern.matcher(literal).find() || (occurrencesByFile = (CounterSet)literalAndInfos.getSecond(i)).getKeys().stream().anyMatch(UniformPathUtils::isArchitectureFile) || occurrencesByFile.getTotal() < parameters.getMinOccurrences() || literal.length() - 2 < parameters.getMinLiteralSize()) continue;
            redundantLiterals.add(new RedundantLiteralInfo(literal, occurrencesByFile.getTotal(), new ArrayList<String>((Collection<String>)occurrencesByFile.getKeys())));
        }
        Comparator<RedundantLiteralInfo> byOccurrencesReversed = Comparator.comparingInt(RedundantLiteralInfo::getOccurrences).reversed();
        redundantLiterals.sort(byOccurrencesReversed);
        return redundantLiterals;
    }

    private List<RedundantLiteralInfo> loadTreemapParameters(RedundantLiteralQueryOptions parameters, UnresolvedCommitDescriptor commit, TreemapQueryOptions treemapRequestOptions, MetricDirectorySchema schema) throws StorageException, BadRequestException {
        treemapRequestOptions.postProcess(schema, false);
        return this.getRedundantLiterals(parameters, commit);
    }

    private PairList<String, CounterSet<String>> getLiteralInfos(boolean localScopeMetric, String cleanPath, HistoryAccessOption historyAccessOption) throws StorageException {
        PairList literalAndInfos = this.openProjectIndex(RedundantLiteralIndex.class, historyAccessOption).getAllRedundantLiterals();
        return this.filterLiteralsByPath((PairList<String, CounterSet<String>>)literalAndInfos, cleanPath, localScopeMetric, historyAccessOption);
    }

    public static class RedundantLiteralInfo {
        private static final String LITERAL_PROPERTY = "literal";
        private static final String OCCURRENCES_PROPERTY = "occurrences";
        private static final String FILES_PROPERTY = "files";
        @JsonProperty(value="literal")
        private final String literal;
        @JsonProperty(value="occurrences")
        private final int occurrences;
        @JsonProperty(value="files")
        private final List<String> files;

        @JsonCreator
        public RedundantLiteralInfo(@JsonProperty(value="literal") String literal, @JsonProperty(value="occurrences") int occurrences, @JsonProperty(value="files") List<String> files) {
            this.literal = literal;
            this.occurrences = occurrences;
            this.files = files;
        }

        public List<String> getFiles() {
            return CollectionUtils.asUnmodifiable(this.files);
        }

        public String getLiteral() {
            return this.literal;
        }

        public int getOccurrences() {
            return this.occurrences;
        }
    }
}

