/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.bitbucket_server.debug;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerWebhookEventIndex;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Path(value="api/projects/{project}/bitbucket-server/debug")
public class DebugBitbucketServerConnectorService
extends ApiBase {
    @GET
    @Path(value="version")
    @Operation(summary="Get the version information of all the Bitbucket Server instances connected to the project.", tags={"Debugging", "Voting Connectors"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Set<String> getServerVersions() throws StorageException, ServiceCallException {
        UnmodifiableList allProjectConnectors = ((ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class)).getConnectors();
        List bitbucketServerConnectors = CollectionUtils.filter((Collection)allProjectConnectors, configuration -> ConnectorUtils.tryCreateConnectorDescriptor((ConnectorConfiguration)configuration).filter(descriptor -> descriptor instanceof BitbucketServerRepositoryConnectorDescriptor).isPresent());
        ExternalCredentialsIndex credentialsIndex = (ExternalCredentialsIndex)this.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class);
        HashSet<String> result = new HashSet<String>();
        for (ConnectorConfiguration connector : bitbucketServerConnectors) {
            ExternalCredentials credentials;
            String credentialsName = connector.getOptionValue("Account");
            if (credentialsName == null || (credentials = credentialsIndex.getExternalCredentials(credentialsName)) == null) continue;
            BitbucketServerClient bitbucketServerClient = new BitbucketServerClient(credentials.uri, credentials.username, credentials.password, null);
            result.add(bitbucketServerClient.getServerVersion());
        }
        return result;
    }

    @GET
    @Path(value="webhook-index")
    @Operation(summary="Get the Bitbucket Server webhook event index content, showing all the events received by Teamscale for the project.", tags={"Debugging", "Voting Connectors"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getWebhookIndexContent() throws StorageException {
        BitbucketServerWebhookEventIndex webhookEventIndex = this.openProjectIndex(BitbucketServerWebhookEventIndex.class, null);
        return webhookEventIndex.getAllRepositoriesToWebhookEvents().toString();
    }
}

