/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.service.findings.refactoring.ExtractMethodCandidate;
import com.teamscale.service.findings.refactoring.Method;
import com.teamscale.service.findings.refactoring.RefactoringAnalysisException;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ExtractMethodCandidatesDeterminer {
    private final Method method;
    private final List<ExtractMethodCandidate> refactoringCandidates = new ArrayList<ExtractMethodCandidate>();
    private final int findingLineNumber;
    private static final Logger LOGGER = LogManager.getLogger();

    public ExtractMethodCandidatesDeterminer(Method method, int findingLineNumber) {
        this.method = method;
        this.findingLineNumber = findingLineNumber;
        this.setRefactoringCandidates(method.getEntity());
        this.optimizeListOfCandidates();
    }

    public List<ExtractMethodCandidate> getRefactoringCandidates() {
        return this.refactoringCandidates;
    }

    private void setRefactoringCandidates(ShallowEntity currentEntity) {
        UnmodifiableList children = currentEntity.getChildren();
        for (int beginIndex = 0; beginIndex < children.size(); ++beginIndex) {
            for (int endIndex = children.size(); endIndex > 0; --endIndex) {
                this.addSingleCandidate((List<ShallowEntity>)children, beginIndex, endIndex);
            }
            if (this.refactoringCandidates.size() > 10000) {
                return;
            }
            if (((ShallowEntity)children.get(beginIndex)).getSubtype().equals("anonymous class") || ((ShallowEntity)children.get(beginIndex)).getSubtype().equals("lambda")) continue;
            this.setRefactoringCandidates((ShallowEntity)children.get(beginIndex));
        }
    }

    private boolean candidateShouldBeConsidered(List<ShallowEntity> candidateEntities) {
        if (this.findingLineNumber == -1) {
            return true;
        }
        CCSMAssert.isTrue((!candidateEntities.isEmpty() ? 1 : 0) != 0, (String)"Expected candidateEntities to be non-empty!");
        int candidateStartLine = candidateEntities.get(0).getStartLine();
        int candidateEndLine = candidateEntities.get(candidateEntities.size() - 1).getEndLine();
        return candidateStartLine <= this.findingLineNumber && candidateEndLine >= this.findingLineNumber;
    }

    private void addSingleCandidate(List<ShallowEntity> children, int beginIndex, int endIndex) {
        List<ShallowEntity> candidateEntities = ExtractMethodCandidatesDeterminer.determineCandidateEntities(children, beginIndex, endIndex);
        if (!ShallowEntityTraversalUtils.listEntitiesOfType(candidateEntities, (EShallowEntityType)EShallowEntityType.STATEMENT).isEmpty() && this.candidateShouldBeConsidered(candidateEntities)) {
            try {
                ExtractMethodCandidate candidate = new ExtractMethodCandidate(this.method, candidateEntities);
                if (candidate.isLongEnough() && candidate.isExtractable()) {
                    this.refactoringCandidates.add(candidate);
                }
            }
            catch (RefactoringAnalysisException e) {
                LOGGER.warn("Could not analyze candidate for beginIndex " + beginIndex + " and endIndex " + endIndex + ". Skipping this one.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Critical error while analyze candidate for beginIndex " + beginIndex + " and endIndex " + endIndex + ". Skipping this one.", (Throwable)e);
            }
        }
    }

    private static List<ShallowEntity> determineCandidateEntities(List<ShallowEntity> children, int beginIndex, int endIndex) {
        ArrayList<ShallowEntity> candidateEntities = new ArrayList<ShallowEntity>();
        for (int i = beginIndex; i < endIndex; ++i) {
            ShallowEntity statement = children.get(i);
            String subType = statement.getSubtype();
            if (subType.equals("if") || subType.equals("try") || subType.equals("switch") || subType.equals("switch expression")) {
                List completeStatement = ShallowParsingUtils.getCompleteStatement((ShallowEntity)statement);
                candidateEntities.addAll(completeStatement);
                continue;
            }
            if (subType.contains("else") || subType.equals("catch") || subType.equals("finally") || subType.equals("case") || subType.equals("default")) continue;
            candidateEntities.add(statement);
        }
        return candidateEntities;
    }

    private void removeNegativeCandidates() {
        Iterator<ExtractMethodCandidate> iterator = this.refactoringCandidates.iterator();
        while (iterator.hasNext()) {
            ExtractMethodCandidate candidate = iterator.next();
            if (!(candidate.getScore() < 0.0)) continue;
            iterator.remove();
        }
    }

    private void removeWorseEmbracedCandidates() {
        ArrayList<ExtractMethodCandidate> removalCandidates = new ArrayList<ExtractMethodCandidate>();
        for (int candidatePosition = 0; candidatePosition < this.refactoringCandidates.size(); ++candidatePosition) {
            ExtractMethodCandidate candidate = this.refactoringCandidates.get(candidatePosition);
            for (int childPos = candidatePosition + 1; childPos < this.refactoringCandidates.size(); ++childPos) {
                ExtractMethodCandidate worseCandidate = this.refactoringCandidates.get(childPos);
                if (!ExtractMethodCandidatesDeterminer.isWorseEmbracedCandidate(candidate, worseCandidate)) continue;
                removalCandidates.add(worseCandidate);
            }
        }
        this.refactoringCandidates.removeAll(removalCandidates);
    }

    private static boolean isWorseEmbracedCandidate(ExtractMethodCandidate candidate, ExtractMethodCandidate worseCandidate) {
        return worseCandidate.getStartLine() >= candidate.getStartLine() && worseCandidate.getEndLine() <= candidate.getEndLine() && worseCandidate.getInputParameters().containsAll(candidate.getInputParameters()) && worseCandidate.getReturnParameters().containsAll(candidate.getReturnParameters());
    }

    public void sortCandidates() {
        if (this.refactoringCandidates.isEmpty()) {
            return;
        }
        Collections.sort(this.refactoringCandidates, Collections.reverseOrder());
    }

    private void optimizeListOfCandidates() {
        this.sortCandidates();
        if (!this.refactoringCandidates.isEmpty() && this.refactoringCandidates.get(0).getScore() >= 0.0) {
            this.removeNegativeCandidates();
        }
        this.removeWorseEmbracedCandidates();
    }
}

