/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.etag.IETagContributor;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.List;
import java.util.TreeMap;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class IssueIndexBaseLastUpdatedContributor<T extends IssueIndexBase<?>>
implements IETagContributor {
    private static final String NOT_CONFIGURED = "NOT_CONFIGURED";
    private final Class<T> indexClass;

    protected IssueIndexBaseLastUpdatedContributor(Class<T> indexClass) {
        CCSMAssert.isNotNull(indexClass, () -> String.format("Expected \"%s\" to be not null", "indexClass"));
        this.indexClass = indexClass;
    }

    public String generateETagFragment(ContainerRequestContext requestContext, ITeamscaleServiceInfo serviceInfo) throws Exception {
        CommitResolvingStorageSystem storageSystem = serviceInfo.getProjectStorageSystem();
        if (storageSystem.hasIndex(this.indexClass)) {
            TreeMap<String, Long> resultRepresentation = new TreeMap<String, Long>();
            for (HistoryAccessOption historyAccessOption : this.getHistoryAccessOptions(serviceInfo)) {
                IssueIndexBase index = (IssueIndexBase)storageSystem.openProjectIndex(this.indexClass, historyAccessOption);
                for (String connectorId : index.getAllConnectorIds()) {
                    long lastChange = index.getLastChange(connectorId).orElse(-1L);
                    resultRepresentation.put(connectorId, lastChange);
                }
            }
            return ((Object)resultRepresentation).toString();
        }
        return NOT_CONFIGURED;
    }

    protected abstract @NonNull List<@Nullable HistoryAccessOption> getHistoryAccessOptions(ITeamscaleServiceInfo var1) throws Exception;
}

