/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.treemap.MethodTreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ChangeMethodsTreeMapBuilder {
    private List<AssociatedMethodInfo> allMethods;
    private final Set<AssociatedMethodInfo> addedMethods;
    private final long lastPassedTestTimestamp;
    private static final Color UNCHANGED_COLOR = Color.decode(ETrafficLightColor.GREEN.getHexValue());
    private static final Color UNCHANGED_METHOD_COVER_CHANGED_COLOR = Color.decode("#17becf");
    private static final Color MODIFIED_COLOR = Color.decode(ETrafficLightColor.ORANGE.getHexValue());

    public ChangeMethodsTreeMapBuilder(List<AssociatedMethodInfo> allMethods, Set<AssociatedMethodInfo> addedMethods, long lastPassedTestTimestamp, boolean excludeUnchangedMethods) {
        this.lastPassedTestTimestamp = lastPassedTestTimestamp;
        this.addedMethods = addedMethods;
        this.allMethods = allMethods;
        if (excludeUnchangedMethods) {
            this.allMethods = allMethods.stream().filter(m -> this.getState((AssociatedMethodInfo)m) != State.UNCHANGED).collect(Collectors.toList());
        }
        this.allMethods.sort(Comparator.comparing(AssociatedMethodInfo::getLocation));
    }

    public MethodTreeMapNode buildTreeMap() throws StorageException, TreeMapBuilderException {
        MethodTreeMapNode root = new MethodTreeMapNode("", "", 0, 0, 0.0, "", null);
        for (AssociatedMethodInfo method : this.allMethods) {
            UniformPath path = method.getLocation().getUniformPath();
            TreeMapNode rootNode = ChangeMethodsTreeMapBuilder.findOrCreateNode((TreeMapNode)root, path);
            rootNode.addChild((TreeMapNodeBase)this.createMethodNode(method));
        }
        root.recalculateAreaAggregates();
        return root;
    }

    private MethodTreeMapNode createMethodNode(AssociatedMethodInfo method) {
        State state = this.getState(method);
        OffsetBasedRegion region = method.getAssociatedRegion();
        int start = region.getStart();
        int end = region.getEnd();
        return new MethodTreeMapNode(method.getUniformPath().toStringAsMigrationFrontier(), method.getMethodName(), start, end, (double)region.getLength(), state.description, state.color);
    }

    private State getState(AssociatedMethodInfo method) {
        if (this.addedMethods.contains(method)) {
            return State.UNCHANGED_METHOD_COVER_CHANGED;
        }
        if (method.getLastChangedTimestamp() > this.lastPassedTestTimestamp) {
            return State.MODIFIED;
        }
        return State.UNCHANGED;
    }

    private static TreeMapNode findOrCreateNode(TreeMapNode root, UniformPath uniformPath) {
        TreeMapNode currentNode = root;
        for (String part : uniformPath.getPathSegments()) {
            TreeMapNode child = (TreeMapNode)currentNode.getChild(part);
            if (child == null) {
                String childUniformPath = UniformPathUtils.concatenate((String[])new String[]{currentNode.getUniformPath(), part});
                child = new TreeMapNode(childUniformPath, 0.0, "", null);
                currentNode.addChild((TreeMapNodeBase)child);
            }
            currentNode = child;
        }
        return currentNode;
    }

    public static enum State {
        UNCHANGED("Unchanged since the last run passed", UNCHANGED_COLOR),
        UNCHANGED_METHOD_COVER_CHANGED("Unchanged method but method coverage changed since the last run passed", UNCHANGED_METHOD_COVER_CHANGED_COLOR),
        MODIFIED("Modified since the last run passed", MODIFIED_COLOR);

        public final String description;
        public final Color color;

        private State(String description, Color color) {
            this.description = description;
            this.color = color;
        }
    }
}

