/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.legacy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.MetricNames;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.structure.metrics.FindingsDensityForSingleCategoryMetric;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/report-data")
public class ReportDataExtractorService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASELINE_PARAMETER_NAME = "baseline";
    private static final String HEAD_PARAMETER_NAME = "head";
    private static final String MAIN_PROJECT_PARAMETER_NAME = "main-project";
    private static final String SUB_PROJECT_PARAMETER_NAME = "sub-project";
    private static final double CLONE_COVERAGE_THRESHOLD = 0.1;
    private static final int CODE_ANOMALIES_DENSITY_THRESHOLD = 10;
    private static final double ASSESSMENT_TREND_EPSILON = 0.001;
    private static final double RED_THRESHOLD = 0.05;
    private static final double RED_YELLOW_THRESHOLD = 0.25;
    private static final NumberFormat PERCENTAGE_FORMAT = NumberFormat.getPercentInstance();
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getInstance();
    private static final String CODE_ANOMALIES_DENSITY = new FindingsDensityForSingleCategoryMetric(MetricNames.FINDINGS_COUNT_BY_CATEGORY.createFindingsCountMetricForCategory("Code Anomalies", false)).getName();
    private final Map<String, MetricDirectoryEntry> headMetrics = new HashMap<String, MetricDirectoryEntry>();
    private final Map<String, MetricDirectoryEntry> baselineMetrics = new HashMap<String, MetricDirectoryEntry>();
    private MetricDirectorySchema schema;

    @GET
    @Operation(summary="Get report data (legacy)", description="This is a legacy service for generating CSV data for use in a quality report. Usage is not recommended as this will be removed in future version. Please use the Reporting feature instead.", tags={"Reporting"})
    @RequiresNoPermission(description="The view permissions are checked for each given project separately.")
    public String getReportData(@Parameter(description="The commit representing the baseline revision of the report.", required=true) @QueryParam(value="baseline") String baseline, @Parameter(description="The commit representing the head revision of the report. Default is now.") @QueryParam(value="head") String head, @Parameter(description="The name of the main project.", required=true) @QueryParam(value="main-project") String mainProject, @Parameter(description="The sub projects for which to export data.") @QueryParam(value="sub-project") List<String> subProjects) throws StorageException {
        this.checkProjectReadPermissions(Collections.singletonList(mainProject));
        this.checkProjectReadPermissions(subProjects);
        CommitDescriptor baselineCommit = CommitDescriptor.fromStringRepresentation((String)baseline);
        CommitDescriptor headCommit = !StringUtils.isEmpty((String)head) ? CommitDescriptor.fromStringRepresentation((String)head) : CommitDescriptor.latestOnBranch((String)baselineCommit.getBranchName());
        this.fetchMetrics(baselineCommit, headCommit, mainProject, subProjects);
        StringBuilder stringBuilder = new StringBuilder();
        this.writeManagementSummary(mainProject, stringBuilder);
        this.writeSizeInformation(stringBuilder, subProjects);
        this.writeDrilldown(stringBuilder, subProjects);
        return stringBuilder.toString();
    }

    private void checkProjectReadPermissions(List<String> projectNames) throws StorageException {
        for (String projectName : projectNames) {
            if (this.getPermissions().mayReadProject((IProjectId)new PublicProjectId(projectName))) continue;
            throw new ForbiddenException("User cannot access " + projectName);
        }
    }

    private void writeManagementSummary(String project, StringBuilder stringBuilder) {
        stringBuilder.append("*** Management Summary ***");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForAssessmentMetric(stringBuilder, project, "File Size Assessment", "very long files", "long files");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForAssessmentMetric(stringBuilder, project, "Method Length Assessment", "very long methods", "long methods");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForAssessmentMetric(stringBuilder, project, "Nesting Depth Assessment", "very deeply nested methods", "deeply nested methods");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForNumericMetric(stringBuilder, project, "Clone Coverage", "clone coverage");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForNumericMetric(stringBuilder, project, CODE_ANOMALIES_DENSITY, "number of code anomalies per 1000 LOC");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForNumericMetric(stringBuilder, project, MetricNames.FINDINGS_COUNT_BY_CATEGORY.createFindingsCountMetricForCategory("Documentation", true).getName(), "number of comment findings");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        this.writeSummaryForNumericMetric(stringBuilder, project, MetricNames.FINDINGS_COUNT_BY_CATEGORY.createFindingsCountMetricForCategory("Architecture", true).getName(), "number of architecture violations");
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
    }

    private void fetchMetrics(CommitDescriptor baselineCommit, CommitDescriptor headCommit, String mainProject, List<String> subProjects) throws StorageException {
        UniformPath mainProjectPath = UniformPathCompatibilityUtil.convert((String)UniformPathUtils.extractProject((String)mainProject));
        ProjectStorageSystem mainProjectStorageSystem = this.openProjectStorageSystem(mainProjectPath.toString());
        this.schema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)mainProjectPath.getType(), (ProjectStorageSystem)mainProjectStorageSystem, (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem())).getMetricDirectorySchema();
        UniformPath mainProjectPathSegments = UniformPathCompatibilityUtil.convert((String)UniformPathUtils.removeFirstSegments((String)mainProjectPath.toString(), (int)1));
        this.headMetrics.put(mainProject, ReportDataExtractorService.fetchMetrics(mainProjectPathSegments, headCommit, mainProjectStorageSystem));
        this.baselineMetrics.put(mainProject, ReportDataExtractorService.fetchMetrics(mainProjectPathSegments, baselineCommit, mainProjectStorageSystem));
        for (String subProject : subProjects) {
            String subProjectPath = UniformPathUtils.extractProject((String)subProject);
            UniformPath subProjectPathSegments = UniformPathCompatibilityUtil.convert((String)UniformPathUtils.removeFirstSegments((String)subProjectPath, (int)1));
            this.headMetrics.put(subProject, ReportDataExtractorService.fetchMetrics(subProjectPathSegments, headCommit, this.openProjectStorageSystem(subProjectPath)));
            this.baselineMetrics.put(subProject, ReportDataExtractorService.fetchMetrics(subProjectPathSegments, baselineCommit, this.openProjectStorageSystem(subProjectPath)));
        }
    }

    private ProjectStorageSystem openProjectStorageSystem(String projectId) throws StorageException {
        return this.getIndexLayer().openProjectStorageSystem((IProjectId)new PublicProjectId(projectId));
    }

    private static MetricDirectoryEntry fetchMetrics(UniformPath pathToFetchMetricsFor, CommitDescriptor commit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)pathToFetchMetricsFor.getType(), (ProjectStorageSystem)projectStorageSystem, null, null, (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory(projectStorageSystem));
        MetricDirectoryEntry entry = metricRetrievalStrategy.getMetricDirectoryEntry(pathToFetchMetricsFor, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        if (entry == null) {
            throw new InternalServerErrorException("No metric value for " + String.valueOf(pathToFetchMetricsFor) + " at " + String.valueOf(commit));
        }
        return entry;
    }

    private void writeSummaryForAssessmentMetric(StringBuilder tableBuilder, String project, String metricName, String textPartRed, String textPartYellow) {
        tableBuilder.append(this.schema.getEntry(this.schema.getValuePosition(metricName)).getName());
        tableBuilder.append(";");
        Assessment assessmentHead = (Assessment)this.getMetricValueHead(project, metricName);
        Assessment assessmentBaseline = (Assessment)this.getMetricValueBaseline(project, metricName);
        String redHeadFormatted = ReportDataExtractorService.getRelativeAmountFormatted(assessmentHead, ETrafficLightColor.RED);
        String redBaselineFormatted = ReportDataExtractorService.getRelativeAmountFormatted(assessmentBaseline, ETrafficLightColor.RED);
        tableBuilder.append(redHeadFormatted);
        tableBuilder.append(" of code in ");
        tableBuilder.append(textPartRed);
        tableBuilder.append(". ");
        String redYellowHeadFormatted = ReportDataExtractorService.getRelativeAmountFormatted(assessmentHead, ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        String redYellowBaselineFormatted = ReportDataExtractorService.getRelativeAmountFormatted(assessmentBaseline, ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        tableBuilder.append(redYellowHeadFormatted);
        tableBuilder.append(" of code in ");
        tableBuilder.append(textPartYellow);
        tableBuilder.append(".;");
        ReportDataExtractorService.appendFullAssessment(tableBuilder, assessmentHead);
        tableBuilder.append(";");
        double redHead = ReportDataExtractorService.getRelativeAmount(assessmentHead, ETrafficLightColor.RED);
        double redYellowHead = ReportDataExtractorService.getRelativeAmount(assessmentHead, ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        double redBaseline = ReportDataExtractorService.getRelativeAmount(assessmentBaseline, ETrafficLightColor.RED);
        double redYellowBaseline = ReportDataExtractorService.getRelativeAmount(assessmentBaseline, ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        if (!redHeadFormatted.equals(redBaselineFormatted)) {
            if (redHead > redBaseline) {
                tableBuilder.append("More");
            } else {
                tableBuilder.append("Less");
            }
            tableBuilder.append(" code in ");
            tableBuilder.append(textPartRed);
            tableBuilder.append(" (was: ");
            tableBuilder.append(redBaselineFormatted);
            tableBuilder.append("). ");
        } else {
            tableBuilder.append("Same amount of code in ").append(textPartRed).append(". ");
        }
        if (!redYellowHeadFormatted.equals(redYellowBaselineFormatted)) {
            if (redYellowHead > redYellowBaseline) {
                tableBuilder.append("More");
            } else {
                tableBuilder.append("Less");
            }
            tableBuilder.append(" code in ");
            tableBuilder.append(textPartYellow);
            tableBuilder.append(" (was: ");
            tableBuilder.append(redYellowBaselineFormatted);
            tableBuilder.append(").");
        } else {
            tableBuilder.append("Same amount of code in ").append(textPartYellow).append(".");
        }
        tableBuilder.append(";");
        ReportDataExtractorService.appendDeltaAssessment(tableBuilder, redHead - redBaseline, redYellowHead - redYellowBaseline);
    }

    private Object getMetricValueHead(String project, String metricName) {
        return this.headMetrics.get(project).getValue(this.schema.getValuePosition(metricName));
    }

    private Object getMetricValueBaseline(String project, String metricName) {
        return this.baselineMetrics.get(project).getValue(this.schema.getValuePosition(metricName));
    }

    private static double getRelativeAmount(Assessment assessment, ETrafficLightColor ... colors) {
        int size = assessment.getSize();
        if (size == 0) {
            return 0.0;
        }
        double amount = 0.0;
        for (ETrafficLightColor color : colors) {
            amount += (double)assessment.getColorFrequency(color);
        }
        return amount / (double)size;
    }

    private static String getRelativeAmountFormatted(Assessment assessment, ETrafficLightColor ... colors) {
        return PERCENTAGE_FORMAT.format(ReportDataExtractorService.getRelativeAmount(assessment, colors));
    }

    private static void appendFullAssessment(StringBuilder tableBuilder, Assessment assessment) {
        double redFraction = ReportDataExtractorService.getRelativeAmount(assessment, ETrafficLightColor.RED);
        double redYellowFraction = ReportDataExtractorService.getRelativeAmount(assessment, ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        if (redFraction <= 0.05 && redYellowFraction <= 0.25) {
            tableBuilder.append(1);
        } else {
            tableBuilder.append(-1);
        }
    }

    private static void appendDeltaAssessment(StringBuilder tableBuilder, double redDelta, double yellowDelta) {
        boolean yellowChanged;
        boolean redChanged = Math.abs(redDelta) > 0.001;
        boolean bl = yellowChanged = Math.abs(yellowDelta) > 0.001;
        if (!redChanged && !yellowChanged) {
            tableBuilder.append(0);
            return;
        }
        double dominantDelta = yellowDelta;
        if (Math.abs(redDelta) > Math.abs(yellowDelta)) {
            dominantDelta = redDelta;
        }
        if (dominantDelta > 0.0) {
            tableBuilder.append(-1);
        } else {
            tableBuilder.append(1);
        }
    }

    private void writeSummaryForNumericMetric(StringBuilder tableBuilder, String project, String metricName, String textPart) {
        int index = this.schema.getValuePosition(metricName);
        if (index == -1) {
            LOGGER.error("Ignoring metric: " + metricName);
            return;
        }
        MetricDirectorySchemaEntry schemaEntry = this.schema.getEntry(index);
        tableBuilder.append(schemaEntry.getName());
        tableBuilder.append(";The ");
        tableBuilder.append(textPart);
        tableBuilder.append(" is ");
        double headValue = (Double)this.getMetricValueHead(project, metricName);
        String headFormatted = ReportDataExtractorService.formatNumericValue(schemaEntry, headValue);
        tableBuilder.append(headFormatted);
        tableBuilder.append(".;");
        this.appendFullAssessmentForNumericMetric(project, tableBuilder, metricName);
        tableBuilder.append(";");
        double baselineValue = (Double)this.getMetricValueBaseline(project, metricName);
        String baselineFormatted = ReportDataExtractorService.formatNumericValue(schemaEntry, baselineValue);
        if (headFormatted.equals(baselineFormatted)) {
            tableBuilder.append("No change.;0");
            return;
        }
        int trend = 0;
        if (headValue > baselineValue) {
            tableBuilder.append("Higher");
            trend = -1;
        } else {
            tableBuilder.append("Lower");
            trend = 1;
        }
        tableBuilder.append(" ");
        tableBuilder.append(textPart);
        tableBuilder.append(" (was:");
        tableBuilder.append(baselineFormatted);
        tableBuilder.append(").;");
        tableBuilder.append(trend);
    }

    private static String formatNumericValue(MetricDirectorySchemaEntry schemaEntry, double value) {
        if (schemaEntry.hasProperty(EMetricProperty.RATIO_METRIC)) {
            return PERCENTAGE_FORMAT.format(value);
        }
        return DECIMAL_FORMAT.format(value);
    }

    private void appendFullAssessmentForNumericMetric(String project, StringBuilder tableBuilder, String metricName) {
        String thresholdFormatted;
        MetricDirectorySchemaEntry schemaEntry = this.schema.getEntry(this.schema.getValuePosition(metricName));
        double value = (Double)this.getMetricValueHead(project, metricName);
        double threshold = ReportDataExtractorService.getThresholdForNumericMetric(metricName);
        String valueFormatted = ReportDataExtractorService.formatNumericValue(schemaEntry, value);
        if (valueFormatted.equals(thresholdFormatted = ReportDataExtractorService.formatNumericValue(schemaEntry, threshold))) {
            tableBuilder.append(1);
            return;
        }
        if (value > threshold) {
            tableBuilder.append(-1);
        } else {
            tableBuilder.append(1);
        }
    }

    private static double getThresholdForNumericMetric(String metricName) {
        if (metricName.equals("Clone Coverage")) {
            return 0.1;
        }
        if (metricName.equals(CODE_ANOMALIES_DENSITY)) {
            return 10.0;
        }
        return 0.0;
    }

    private void writeSizeInformation(StringBuilder tableBuilder, List<String> subProjects) {
        tableBuilder.append("*** Size Information ***");
        tableBuilder.append(StringUtils.LINE_SEPARATOR);
        for (String subProject : subProjects) {
            tableBuilder.append(subProject);
            tableBuilder.append(";");
            tableBuilder.append(((Double)this.getMetricValueHead(subProject, "Files")).intValue());
            tableBuilder.append(";");
            tableBuilder.append(((Double)this.getMetricValueHead(subProject, "Lines of Code")).intValue());
            tableBuilder.append(";");
            tableBuilder.append(((Double)this.getMetricValueHead(subProject, "Source Lines of Code")).intValue());
            tableBuilder.append(StringUtils.LINE_SEPARATOR);
        }
        tableBuilder.append(StringUtils.LINE_SEPARATOR);
    }

    private void writeDrilldown(StringBuilder stringBuilder, List<String> subProjects) {
        stringBuilder.append(this.generateMetricTable("File Size Assessment", subProjects));
        stringBuilder.append(this.generateMetricTable("Method Length Assessment", subProjects));
        stringBuilder.append(this.generateMetricTable("Nesting Depth Assessment", subProjects));
        stringBuilder.append(this.generateMetricTable("Clone Coverage", subProjects));
        stringBuilder.append(this.generateMetricTable(CODE_ANOMALIES_DENSITY, subProjects));
        stringBuilder.append(this.generateMetricTable(MetricNames.FINDINGS_COUNT_BY_CATEGORY.createFindingsCountMetricForCategory("Documentation", true).getName(), subProjects));
        stringBuilder.append(this.generateMetricTable(MetricNames.FINDINGS_COUNT_BY_CATEGORY.createFindingsCountMetricForCategory("Architecture", true).getName(), subProjects));
    }

    private String generateMetricTable(String metricName, List<String> subProjects) {
        StringBuilder result = new StringBuilder();
        result.append("***").append(metricName).append("***");
        result.append(StringUtils.LINE_SEPARATOR);
        for (String subProject : subProjects) {
            this.appendMetricTableRow(metricName, result, subProject);
            result.append(StringUtils.LINE_SEPARATOR);
        }
        result.append(StringUtils.LINE_SEPARATOR);
        return result.toString();
    }

    private void appendMetricTableRow(String metricName, StringBuilder tableBuilder, String subPath) {
        int metricIndex = this.schema.getValuePosition(metricName);
        if (metricIndex == -1) {
            LOGGER.error("Ignoring unknown metric: " + metricName);
            return;
        }
        tableBuilder.append(subPath);
        tableBuilder.append(";");
        MetricDirectoryEntry headEntry = this.headMetrics.get(subPath);
        MetricDirectoryEntry baselineEntry = this.baselineMetrics.get(subPath);
        MetricDirectorySchemaEntry schemaEntry = this.schema.getEntry(metricIndex);
        switch (schemaEntry.getValueType()) {
            case ASSESSMENT: {
                ReportDataExtractorService.appendAssessmentValues(tableBuilder, headEntry, baselineEntry, metricIndex);
                break;
            }
            case NUMERIC: {
                this.appendNumericMetricValues(subPath, tableBuilder, schemaEntry, headEntry, baselineEntry, metricIndex);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported metric value type: " + String.valueOf(schemaEntry.getValueType()));
            }
        }
    }

    private static void appendAssessmentValues(StringBuilder tableBuilder, MetricDirectoryEntry headEntry, MetricDirectoryEntry baselineEntry, int metricIndex) {
        Assessment assessmentHead = (Assessment)headEntry.getValue(metricIndex);
        Assessment assessmentBaseline = (Assessment)baselineEntry.getValue(metricIndex);
        int overallHead = assessmentHead.getSize();
        int overallBaseline = assessmentBaseline.getSize();
        if (overallHead != 0 && overallBaseline != 0) {
            double redHead = (double)assessmentHead.getColorFrequency(ETrafficLightColor.RED) / (double)overallHead;
            double redBaseline = (double)assessmentBaseline.getColorFrequency(ETrafficLightColor.RED) / (double)overallBaseline;
            double redDelta = redHead - redBaseline;
            tableBuilder.append(PERCENTAGE_FORMAT.format(redHead));
            ReportDataExtractorService.appendAssessmentDeltaValue(tableBuilder, redDelta);
            tableBuilder.append(";");
            double yellowRedHead = ((double)assessmentHead.getColorFrequency(ETrafficLightColor.YELLOW) + (double)assessmentHead.getColorFrequency(ETrafficLightColor.RED)) / (double)overallHead;
            double yellowRedBaseline = ((double)assessmentBaseline.getColorFrequency(ETrafficLightColor.YELLOW) + (double)assessmentBaseline.getColorFrequency(ETrafficLightColor.RED)) / (double)overallBaseline;
            tableBuilder.append(PERCENTAGE_FORMAT.format(yellowRedHead));
            double yellowDelta = yellowRedHead - yellowRedBaseline;
            ReportDataExtractorService.appendAssessmentDeltaValue(tableBuilder, yellowDelta);
            tableBuilder.append(";");
            ReportDataExtractorService.appendFullAssessment(tableBuilder, assessmentHead);
            tableBuilder.append(";");
            ReportDataExtractorService.appendDeltaAssessment(tableBuilder, redDelta, yellowDelta);
        }
    }

    private static void appendAssessmentDeltaValue(StringBuilder tableBuilder, double delta) {
        tableBuilder.append(" (");
        if (Math.abs(delta) <= 0.001) {
            tableBuilder.append("+/-");
            delta = 0.0;
        } else if (delta > 0.0) {
            tableBuilder.append("+");
        }
        tableBuilder.append(PERCENTAGE_FORMAT.format(delta));
        tableBuilder.append(")");
    }

    private void appendNumericMetricValues(String project, StringBuilder tableBuilder, MetricDirectorySchemaEntry schemaEntry, MetricDirectoryEntry headEntry, MetricDirectoryEntry baselineEntry, int metricIndex) {
        double valueHead = (Double)headEntry.getValue(metricIndex);
        double valueBaseline = (Double)baselineEntry.getValue(metricIndex);
        String valueHeadFormatted = ReportDataExtractorService.formatNumericValue(schemaEntry, valueHead);
        tableBuilder.append(valueHeadFormatted);
        tableBuilder.append(" (");
        int trend = 0;
        double delta = valueHead - valueBaseline;
        if (ReportDataExtractorService.isRelevantNumericMetricDelta(delta, schemaEntry)) {
            if (delta > 0.0) {
                trend = -1;
                tableBuilder.append("+");
            } else {
                trend = 1;
            }
            tableBuilder.append(ReportDataExtractorService.formatNumericValue(schemaEntry, delta));
        } else {
            tableBuilder.append("+/-").append(ReportDataExtractorService.formatNumericValue(schemaEntry, 0.0));
            trend = 0;
        }
        tableBuilder.append(");");
        this.appendFullAssessmentForNumericMetric(project, tableBuilder, schemaEntry.getName());
        tableBuilder.append(";");
        tableBuilder.append(trend);
    }

    private static boolean isRelevantNumericMetricDelta(double delta, MetricDirectorySchemaEntry schemaEntry) {
        if (schemaEntry.hasProperty(EMetricProperty.RATIO_METRIC)) {
            return Math.abs(delta) >= 0.001;
        }
        if (schemaEntry.getName().equals(CODE_ANOMALIES_DENSITY)) {
            return Math.abs(delta) >= 0.1;
        }
        return Math.abs(delta) >= 1.0;
    }

    static {
        PERCENTAGE_FORMAT.setMinimumFractionDigits(1);
        DECIMAL_FORMAT.setMaximumFractionDigits(1);
    }
}

