/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import java.util.HashMap;
import java.util.Map;

class IdentifierAnonymizer {
    private static final int ANONYMOUS_NAME_UNIQUE_COMPONENT_OFFSET = 27;
    private final Map<String, String> identifierToAnonymousIdMap = new HashMap<String, String>();
    private char lastCharacter = (char)96;

    IdentifierAnonymizer() {
    }

    public String anonymize(String identifier) {
        String mappedID = this.identifierToAnonymousIdMap.get(identifier);
        if (mappedID != null) {
            return mappedID;
        }
        StringBuilder result = new StringBuilder();
        CharacterCounter characterCounter = new CharacterCounter();
        for (char c : identifier.toCharArray()) {
            if (Character.isUpperCase(c)) {
                ++characterCounter.upperCaseLetters;
            } else if (Character.isLowerCase(c) && result.length() > 1) {
                ++characterCounter.lowerCaseLetters;
            } else if (c == '-') {
                ++characterCounter.dashes;
            } else if (c == '_' && result.length() > 2) {
                ++characterCounter.underscores;
            }
            result.append(this.substituteChar(c));
        }
        String suffix = IdentifierAnonymizer.determineUnderscoredSuffix(result, characterCounter);
        this.appendUniqueComponent(result, characterCounter);
        result.append(suffix);
        this.identifierToAnonymousIdMap.put(identifier, result.toString());
        return result.toString();
    }

    private char substituteChar(char in) {
        if (!Character.isLetter(in)) {
            return in;
        }
        if (Character.isUpperCase(in)) {
            return Character.toUpperCase(this.deriveAnonymizedCharacter());
        }
        return this.deriveAnonymizedCharacter();
    }

    private static String determineUnderscoredSuffix(StringBuilder result, CharacterCounter characterCounter) {
        if (result.toString().endsWith("__")) {
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
            characterCounter.underscores -= 2;
            return "__";
        }
        if (result.toString().endsWith("_")) {
            result.deleteCharAt(result.length() - 1);
            --characterCounter.underscores;
            return "_";
        }
        if (result.length() > 2 && result.charAt(result.length() - 2) == '_') {
            char suffixCharacter = result.charAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
            --characterCounter.underscores;
            return "_" + suffixCharacter;
        }
        return "";
    }

    private void appendUniqueComponent(StringBuilder identifier, CharacterCounter characterCounter) {
        String unique = IdentifierAnonymizer.encodeBase26(this.identifierToAnonymousIdMap.size() + 27);
        if (characterCounter.lowerCaseLetters == 0 && characterCounter.underscores >= 1) {
            identifier.append("Z_");
            identifier.append(unique.toUpperCase());
        } else if (characterCounter.lowerCaseLetters == 0 && characterCounter.dashes >= 1) {
            identifier.append("Z-");
            identifier.append(unique.toUpperCase());
        } else if (characterCounter.upperCaseLetters == 0 && characterCounter.underscores >= 1) {
            identifier.append("z_");
            identifier.append(unique);
        } else if (characterCounter.upperCaseLetters == 0 && characterCounter.dashes >= 1) {
            identifier.append("z-");
            identifier.append(unique);
        } else if (characterCounter.lowerCaseLetters == 0 && characterCounter.dashes == 0 && characterCounter.underscores == 0) {
            identifier.append("Z");
            identifier.append(unique.toUpperCase());
        } else if (characterCounter.lowerCaseLetters > characterCounter.upperCaseLetters && characterCounter.underscores >= 1) {
            identifier.append("z_");
            identifier.append(IdentifierAnonymizer.asTitleCase(unique));
        } else if (characterCounter.lowerCaseLetters > characterCounter.upperCaseLetters && characterCounter.dashes >= 1) {
            identifier.append("z-");
            identifier.append(IdentifierAnonymizer.asTitleCase(unique));
        } else if (characterCounter.lowerCaseLetters > characterCounter.upperCaseLetters && characterCounter.upperCaseLetters >= 1) {
            identifier.append("z");
            identifier.append(IdentifierAnonymizer.asTitleCase(unique));
        } else {
            identifier.append("z");
            identifier.append(unique);
        }
    }

    private char deriveAnonymizedCharacter() {
        this.lastCharacter = (char)((this.lastCharacter - 97 + 1) % 25 + 97);
        return this.lastCharacter;
    }

    private static String encodeBase26(int i) {
        int diff;
        StringBuilder result = new StringBuilder();
        do {
            diff = (int)((double)i % Math.pow(26.0, result.length() + 1));
            result.append((char)(97 + diff % 26));
        } while ((i -= diff) > 0);
        return result.reverse().toString();
    }

    private static String asTitleCase(String input) {
        char[] chars = input.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static class CharacterCounter {
        int dashes = 0;
        int underscores = 0;
        int upperCaseLetters = 0;
        int lowerCaseLetters = 0;

        private CharacterCounter() {
        }
    }
}

