/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.RevisionResolver;
import com.teamscale.index.testimpact.CommitAndRevision;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.testimpact.TiaRequestOptions;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public record TiaDataRetrieverOptions(TiaRequestOptions tiaRequestOptions, CommitDescriptor baselineCommit, CommitDescriptor endCommit, Set<String> partitions) {
    public static TiaDataRetrieverOptions create(TiaRequestOptions tiaRequestOptions, InternalProjectId projectId, User user, IndexLayer indexLayer) throws StorageException {
        CommitDescriptor baselineCommit = RevisionResolver.resolveRevisionOrCommit((CommitAndRevision)tiaRequestOptions.getBaselineDescriptor(), (String)user.getUsername(), (InternalProjectId)projectId, (IndexLayer)indexLayer);
        CommitDescriptor endCommit = RevisionResolver.resolveRevisionOrCommit((CommitAndRevision)tiaRequestOptions.getEndDescriptor(), (String)user.getUsername(), (InternalProjectId)projectId, (IndexLayer)indexLayer);
        Set<String> partitions = TiaDataRetrieverOptions.getPartitions(tiaRequestOptions.getPartitionInfo(), endCommit, indexLayer.openProjectStorageSystem((IProjectId)projectId));
        return new TiaDataRetrieverOptions(tiaRequestOptions, baselineCommit, endCommit, partitions);
    }

    private static Set<String> getPartitions(TiaPartitionsQueryParams partitionInfo, CommitDescriptor endCommit, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        if (partitionInfo.isAllPartitions()) {
            CoverageUnitToMethodsMapIndex testsToMethodsMapIndex = (CoverageUnitToMethodsMapIndex)projectStorageSystem.openProjectIndex(CoverageUnitToMethodsMapIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)endCommit));
            return new HashSet<String>(testsToMethodsMapIndex.getPartitions());
        }
        return new HashSet<String>(partitionInfo.getPartitions());
    }

    public CommitDescriptor getBaselineCommit() {
        return this.baselineCommit;
    }

    public long getResolvedBaselineTimestamp() {
        return this.baselineCommit.getTimestamp();
    }

    public CommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }
}

