/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user.notifications;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.project.ProjectNotificationRule;
import com.teamscale.index.notifications.project.ProjectNotificationRuleIndex;
import com.teamscale.index.notifications.project.ProjectNotificationRules;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/notification-rules/project")
public class ProjectNotificationRuleService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get project notification rules", description="Retrieves the currently set project notification rules", tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_NOTIFICATION_SETTINGS})
    @ApiResponse(responseCode="204", description="No project notification rules declared.")
    public ProjectNotificationRules getProjectNotificationRules() throws StorageException {
        return this.openGlobalIndex(ProjectNotificationRuleIndex.class).getNotificationRules().orElse(null);
    }

    @PUT
    @Operation(summary="Set project notification rules", description="Edits the currently set project notification rules", tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_NOTIFICATION_SETTINGS})
    public void setProjectNotificationRules(@RequestBody ProjectNotificationRules notificationRules) throws StorageException {
        List validatedRulesWithConstants = this.getOnlyValidRules((List)notificationRules.getRulesWithConstantThreshold());
        List validatedRulesWithConfiguration = this.getOnlyValidRules((List)notificationRules.getRulesWithThresholdFromConfiguration());
        ProjectNotificationRules validProjectNotificationRules = new ProjectNotificationRules(validatedRulesWithConstants, validatedRulesWithConfiguration);
        this.openGlobalIndex(ProjectNotificationRuleIndex.class).setNotificationRules(validProjectNotificationRules);
    }

    private <T extends ProjectNotificationRule> List<T> getOnlyValidRules(List<T> rules) {
        ArrayList validatedRules = new ArrayList();
        for (ProjectNotificationRule rule : rules) {
            this.appendIfValid(validatedRules, rule);
        }
        return validatedRules;
    }

    private <T extends ProjectNotificationRule> void appendIfValid(List<T> validatedRules, T rule) {
        try {
            rule.checkValidity();
            validatedRules.add(rule);
        }
        catch (InvalidNotificationRuleException e) {
            LOGGER.warn("Creation of invalid project notification rule '" + rule.getRuleName() + "'.", (Throwable)e);
        }
    }
}

